/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Represents a customer invoice associated with a purchase order.")
public class CustomerInvoice {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="content")
    private String content = null;

    public CustomerInvoice purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The purchase order number for this order.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public CustomerInvoice content(String content) {
        this.content = content;
        return this;
    }

    @Schema(required=true, description="The Base64 customer invoice.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerInvoice customerInvoice = (CustomerInvoice)o;
        return Objects.equals(this.purchaseOrderNumber, customerInvoice.purchaseOrderNumber) && Objects.equals(this.content, customerInvoice.content);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerInvoice {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

