/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.shipping.v2021_12_28;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Dimensions;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.PackedItem;
import software.amazon.spapi.models.vendor.df.shipping.v2021_12_28.Weight;

@Schema(description="A container used for shipping and packing items.")
public class Container {
    @SerializedName(value="containerType")
    private ContainerTypeEnum containerType = null;
    @SerializedName(value="containerIdentifier")
    private String containerIdentifier = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="manifestId")
    private String manifestId = null;
    @SerializedName(value="manifestDate")
    private String manifestDate = null;
    @SerializedName(value="shipMethod")
    private String shipMethod = null;
    @SerializedName(value="scacCode")
    private String scacCode = null;
    @SerializedName(value="carrier")
    private String carrier = null;
    @SerializedName(value="containerSequenceNumber")
    private Integer containerSequenceNumber = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="packedItems")
    private List<PackedItem> packedItems = new ArrayList<PackedItem>();

    public Container containerType(ContainerTypeEnum containerType) {
        this.containerType = containerType;
        return this;
    }

    @Schema(required=true, description="The type of container.")
    public ContainerTypeEnum getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ContainerTypeEnum containerType) {
        this.containerType = containerType;
    }

    public Container containerIdentifier(String containerIdentifier) {
        this.containerIdentifier = containerIdentifier;
        return this;
    }

    @Schema(required=true, description="The container identifier.")
    public String getContainerIdentifier() {
        return this.containerIdentifier;
    }

    public void setContainerIdentifier(String containerIdentifier) {
        this.containerIdentifier = containerIdentifier;
    }

    public Container trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(description="The tracking number.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Container manifestId(String manifestId) {
        this.manifestId = manifestId;
        return this;
    }

    @Schema(description="The manifest identifier.")
    public String getManifestId() {
        return this.manifestId;
    }

    public void setManifestId(String manifestId) {
        this.manifestId = manifestId;
    }

    public Container manifestDate(String manifestDate) {
        this.manifestDate = manifestDate;
        return this;
    }

    @Schema(description="The date of the manifest.")
    public String getManifestDate() {
        return this.manifestDate;
    }

    public void setManifestDate(String manifestDate) {
        this.manifestDate = manifestDate;
    }

    public Container shipMethod(String shipMethod) {
        this.shipMethod = shipMethod;
        return this;
    }

    @Schema(description="The shipment method. This property is required when calling the `submitShipmentConfirmations` operation, and optional otherwise.")
    public String getShipMethod() {
        return this.shipMethod;
    }

    public void setShipMethod(String shipMethod) {
        this.shipMethod = shipMethod;
    }

    public Container scacCode(String scacCode) {
        this.scacCode = scacCode;
        return this;
    }

    @Schema(description="SCAC code required for NA VOC vendors only.")
    public String getScacCode() {
        return this.scacCode;
    }

    public void setScacCode(String scacCode) {
        this.scacCode = scacCode;
    }

    public Container carrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    @Schema(description="Carrier required for EU VOC vendors only.")
    public String getCarrier() {
        return this.carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public Container containerSequenceNumber(Integer containerSequenceNumber) {
        this.containerSequenceNumber = containerSequenceNumber;
        return this;
    }

    @Schema(description="An integer that must be submitted for multi-box shipments only, where one item may come in separate packages.")
    public Integer getContainerSequenceNumber() {
        return this.containerSequenceNumber;
    }

    public void setContainerSequenceNumber(Integer containerSequenceNumber) {
        this.containerSequenceNumber = containerSequenceNumber;
    }

    public Container dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Container weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(required=true, description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Container packedItems(List<PackedItem> packedItems) {
        this.packedItems = packedItems;
        return this;
    }

    public Container addPackedItemsItem(PackedItem packedItemsItem) {
        this.packedItems.add(packedItemsItem);
        return this;
    }

    @Schema(required=true, description="A list of packed items.")
    public List<PackedItem> getPackedItems() {
        return this.packedItems;
    }

    public void setPackedItems(List<PackedItem> packedItems) {
        this.packedItems = packedItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals((Object)this.containerType, (Object)container.containerType) && Objects.equals(this.containerIdentifier, container.containerIdentifier) && Objects.equals(this.trackingNumber, container.trackingNumber) && Objects.equals(this.manifestId, container.manifestId) && Objects.equals(this.manifestDate, container.manifestDate) && Objects.equals(this.shipMethod, container.shipMethod) && Objects.equals(this.scacCode, container.scacCode) && Objects.equals(this.carrier, container.carrier) && Objects.equals(this.containerSequenceNumber, container.containerSequenceNumber) && Objects.equals(this.dimensions, container.dimensions) && Objects.equals(this.weight, container.weight) && Objects.equals(this.packedItems, container.packedItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerType, this.containerIdentifier, this.trackingNumber, this.manifestId, this.manifestDate, this.shipMethod, this.scacCode, this.carrier, this.containerSequenceNumber, this.dimensions, this.weight, this.packedItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Container {\n");
        sb.append("    containerType: ").append(this.toIndentedString((Object)this.containerType)).append("\n");
        sb.append("    containerIdentifier: ").append(this.toIndentedString(this.containerIdentifier)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    manifestId: ").append(this.toIndentedString(this.manifestId)).append("\n");
        sb.append("    manifestDate: ").append(this.toIndentedString(this.manifestDate)).append("\n");
        sb.append("    shipMethod: ").append(this.toIndentedString(this.shipMethod)).append("\n");
        sb.append("    scacCode: ").append(this.toIndentedString(this.scacCode)).append("\n");
        sb.append("    carrier: ").append(this.toIndentedString(this.carrier)).append("\n");
        sb.append("    containerSequenceNumber: ").append(this.toIndentedString(this.containerSequenceNumber)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    packedItems: ").append(this.toIndentedString(this.packedItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContainerTypeEnum {
        CARTON("Carton"),
        PALLET("Pallet");

        private String value;

        private ContainerTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContainerTypeEnum fromValue(String input) {
            for (ContainerTypeEnum b : ContainerTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContainerTypeEnum> {
            public void write(JsonWriter jsonWriter, ContainerTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ContainerTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContainerTypeEnum.fromValue(value);
            }
        }
    }
}

