/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.payments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.payments.v1.Address;
import software.amazon.spapi.models.vendor.df.payments.v1.TaxRegistrationDetail;

@Schema(description="Name, address and tax details of a party.")
public class PartyIdentification {
    @SerializedName(value="partyId")
    private String partyId = null;
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="taxRegistrationDetails")
    private List<TaxRegistrationDetail> taxRegistrationDetails = null;

    public PartyIdentification partyId(String partyId) {
        this.partyId = partyId;
        return this;
    }

    @Schema(required=true, description="Assigned Identification for the party.")
    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public PartyIdentification address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public PartyIdentification taxRegistrationDetails(List<TaxRegistrationDetail> taxRegistrationDetails) {
        this.taxRegistrationDetails = taxRegistrationDetails;
        return this;
    }

    public PartyIdentification addTaxRegistrationDetailsItem(TaxRegistrationDetail taxRegistrationDetailsItem) {
        if (this.taxRegistrationDetails == null) {
            this.taxRegistrationDetails = new ArrayList<TaxRegistrationDetail>();
        }
        this.taxRegistrationDetails.add(taxRegistrationDetailsItem);
        return this;
    }

    @Schema(description="Tax registration details of the entity.")
    public List<TaxRegistrationDetail> getTaxRegistrationDetails() {
        return this.taxRegistrationDetails;
    }

    public void setTaxRegistrationDetails(List<TaxRegistrationDetail> taxRegistrationDetails) {
        this.taxRegistrationDetails = taxRegistrationDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartyIdentification partyIdentification = (PartyIdentification)o;
        return Objects.equals(this.partyId, partyIdentification.partyId) && Objects.equals(this.address, partyIdentification.address) && Objects.equals(this.taxRegistrationDetails, partyIdentification.taxRegistrationDetails);
    }

    public int hashCode() {
        return Objects.hash(this.partyId, this.address, this.taxRegistrationDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartyIdentification {\n");
        sb.append("    partyId: ").append(this.toIndentedString(this.partyId)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    taxRegistrationDetails: ").append(this.toIndentedString(this.taxRegistrationDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

