/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.payments.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.df.payments.v1.AdditionalDetails;
import software.amazon.spapi.models.vendor.df.payments.v1.ChargeDetails;
import software.amazon.spapi.models.vendor.df.payments.v1.InvoiceItem;
import software.amazon.spapi.models.vendor.df.payments.v1.Money;
import software.amazon.spapi.models.vendor.df.payments.v1.PartyIdentification;
import software.amazon.spapi.models.vendor.df.payments.v1.TaxDetail;

@Schema(description="Represents the details of an invoice, including invoice number, date, parties involved, payment terms, totals, taxes, charges, and line items.")
public class InvoiceDetail {
    @SerializedName(value="invoiceNumber")
    private String invoiceNumber = null;
    @SerializedName(value="invoiceDate")
    private OffsetDateTime invoiceDate = null;
    @SerializedName(value="referenceNumber")
    private String referenceNumber = null;
    @SerializedName(value="remitToParty")
    private PartyIdentification remitToParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="billToParty")
    private PartyIdentification billToParty = null;
    @SerializedName(value="shipToCountryCode")
    private String shipToCountryCode = null;
    @SerializedName(value="paymentTermsCode")
    private String paymentTermsCode = null;
    @SerializedName(value="invoiceTotal")
    private Money invoiceTotal = null;
    @SerializedName(value="taxTotals")
    private List<TaxDetail> taxTotals = null;
    @SerializedName(value="additionalDetails")
    private List<AdditionalDetails> additionalDetails = null;
    @SerializedName(value="chargeDetails")
    private List<ChargeDetails> chargeDetails = null;
    @SerializedName(value="items")
    private List<InvoiceItem> items = new ArrayList<InvoiceItem>();

    public InvoiceDetail invoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @Schema(required=true, description="The unique invoice number.")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public InvoiceDetail invoiceDate(OffsetDateTime invoiceDate) {
        this.invoiceDate = invoiceDate;
        return this;
    }

    @Schema(required=true, description="Invoice date.")
    public OffsetDateTime getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(OffsetDateTime invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public InvoiceDetail referenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
        return this;
    }

    @Schema(description="An additional unique reference number used for regulatory or other purposes.")
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public InvoiceDetail remitToParty(PartyIdentification remitToParty) {
        this.remitToParty = remitToParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getRemitToParty() {
        return this.remitToParty;
    }

    public void setRemitToParty(PartyIdentification remitToParty) {
        this.remitToParty = remitToParty;
    }

    public InvoiceDetail shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public InvoiceDetail billToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
        return this;
    }

    @Schema(description="")
    public PartyIdentification getBillToParty() {
        return this.billToParty;
    }

    public void setBillToParty(PartyIdentification billToParty) {
        this.billToParty = billToParty;
    }

    public InvoiceDetail shipToCountryCode(String shipToCountryCode) {
        this.shipToCountryCode = shipToCountryCode;
        return this;
    }

    @Schema(description="Ship-to country code.")
    public String getShipToCountryCode() {
        return this.shipToCountryCode;
    }

    public void setShipToCountryCode(String shipToCountryCode) {
        this.shipToCountryCode = shipToCountryCode;
    }

    public InvoiceDetail paymentTermsCode(String paymentTermsCode) {
        this.paymentTermsCode = paymentTermsCode;
        return this;
    }

    @Schema(description="The payment terms for the invoice.")
    public String getPaymentTermsCode() {
        return this.paymentTermsCode;
    }

    public void setPaymentTermsCode(String paymentTermsCode) {
        this.paymentTermsCode = paymentTermsCode;
    }

    public InvoiceDetail invoiceTotal(Money invoiceTotal) {
        this.invoiceTotal = invoiceTotal;
        return this;
    }

    @Schema(required=true, description="")
    public Money getInvoiceTotal() {
        return this.invoiceTotal;
    }

    public void setInvoiceTotal(Money invoiceTotal) {
        this.invoiceTotal = invoiceTotal;
    }

    public InvoiceDetail taxTotals(List<TaxDetail> taxTotals) {
        this.taxTotals = taxTotals;
        return this;
    }

    public InvoiceDetail addTaxTotalsItem(TaxDetail taxTotalsItem) {
        if (this.taxTotals == null) {
            this.taxTotals = new ArrayList<TaxDetail>();
        }
        this.taxTotals.add(taxTotalsItem);
        return this;
    }

    @Schema(description="Individual tax details per line item.")
    public List<TaxDetail> getTaxTotals() {
        return this.taxTotals;
    }

    public void setTaxTotals(List<TaxDetail> taxTotals) {
        this.taxTotals = taxTotals;
    }

    public InvoiceDetail additionalDetails(List<AdditionalDetails> additionalDetails) {
        this.additionalDetails = additionalDetails;
        return this;
    }

    public InvoiceDetail addAdditionalDetailsItem(AdditionalDetails additionalDetailsItem) {
        if (this.additionalDetails == null) {
            this.additionalDetails = new ArrayList<AdditionalDetails>();
        }
        this.additionalDetails.add(additionalDetailsItem);
        return this;
    }

    @Schema(description="Additional details provided by the selling party, for tax-related or other purposes.")
    public List<AdditionalDetails> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(List<AdditionalDetails> additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public InvoiceDetail chargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
        return this;
    }

    public InvoiceDetail addChargeDetailsItem(ChargeDetails chargeDetailsItem) {
        if (this.chargeDetails == null) {
            this.chargeDetails = new ArrayList<ChargeDetails>();
        }
        this.chargeDetails.add(chargeDetailsItem);
        return this;
    }

    @Schema(description="Total charge amount details for all line items.")
    public List<ChargeDetails> getChargeDetails() {
        return this.chargeDetails;
    }

    public void setChargeDetails(List<ChargeDetails> chargeDetails) {
        this.chargeDetails = chargeDetails;
    }

    public InvoiceDetail items(List<InvoiceItem> items) {
        this.items = items;
        return this;
    }

    public InvoiceDetail addItemsItem(InvoiceItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="Provides the details of the items in this invoice.")
    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public void setItems(List<InvoiceItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceDetail invoiceDetail = (InvoiceDetail)o;
        return Objects.equals(this.invoiceNumber, invoiceDetail.invoiceNumber) && Objects.equals(this.invoiceDate, invoiceDetail.invoiceDate) && Objects.equals(this.referenceNumber, invoiceDetail.referenceNumber) && Objects.equals(this.remitToParty, invoiceDetail.remitToParty) && Objects.equals(this.shipFromParty, invoiceDetail.shipFromParty) && Objects.equals(this.billToParty, invoiceDetail.billToParty) && Objects.equals(this.shipToCountryCode, invoiceDetail.shipToCountryCode) && Objects.equals(this.paymentTermsCode, invoiceDetail.paymentTermsCode) && Objects.equals(this.invoiceTotal, invoiceDetail.invoiceTotal) && Objects.equals(this.taxTotals, invoiceDetail.taxTotals) && Objects.equals(this.additionalDetails, invoiceDetail.additionalDetails) && Objects.equals(this.chargeDetails, invoiceDetail.chargeDetails) && Objects.equals(this.items, invoiceDetail.items);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceNumber, this.invoiceDate, this.referenceNumber, this.remitToParty, this.shipFromParty, this.billToParty, this.shipToCountryCode, this.paymentTermsCode, this.invoiceTotal, this.taxTotals, this.additionalDetails, this.chargeDetails, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceDetail {\n");
        sb.append("    invoiceNumber: ").append(this.toIndentedString(this.invoiceNumber)).append("\n");
        sb.append("    invoiceDate: ").append(this.toIndentedString(this.invoiceDate)).append("\n");
        sb.append("    referenceNumber: ").append(this.toIndentedString(this.referenceNumber)).append("\n");
        sb.append("    remitToParty: ").append(this.toIndentedString(this.remitToParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    billToParty: ").append(this.toIndentedString(this.billToParty)).append("\n");
        sb.append("    shipToCountryCode: ").append(this.toIndentedString(this.shipToCountryCode)).append("\n");
        sb.append("    paymentTermsCode: ").append(this.toIndentedString(this.paymentTermsCode)).append("\n");
        sb.append("    invoiceTotal: ").append(this.toIndentedString(this.invoiceTotal)).append("\n");
        sb.append("    taxTotals: ").append(this.toIndentedString(this.taxTotals)).append("\n");
        sb.append("    additionalDetails: ").append(this.toIndentedString(this.additionalDetails)).append("\n");
        sb.append("    chargeDetails: ").append(this.toIndentedString(this.chargeDetails)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

