/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.ItemQuantity;

@Schema(description="Details of an individual item within the order being acknowledged.")
public class OrderItemAcknowledgement {
    @SerializedName(value="itemSequenceNumber")
    private String itemSequenceNumber = null;
    @SerializedName(value="buyerProductIdentifier")
    private String buyerProductIdentifier = null;
    @SerializedName(value="vendorProductIdentifier")
    private String vendorProductIdentifier = null;
    @SerializedName(value="acknowledgedQuantity")
    private ItemQuantity acknowledgedQuantity = null;

    public OrderItemAcknowledgement itemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
        return this;
    }

    @Schema(required=true, description="Line item sequence number for the item.")
    public String getItemSequenceNumber() {
        return this.itemSequenceNumber;
    }

    public void setItemSequenceNumber(String itemSequenceNumber) {
        this.itemSequenceNumber = itemSequenceNumber;
    }

    public OrderItemAcknowledgement buyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
        return this;
    }

    @Schema(description="Buyer's standard identification number (ASIN) of an item.")
    public String getBuyerProductIdentifier() {
        return this.buyerProductIdentifier;
    }

    public void setBuyerProductIdentifier(String buyerProductIdentifier) {
        this.buyerProductIdentifier = buyerProductIdentifier;
    }

    public OrderItemAcknowledgement vendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
        return this;
    }

    @Schema(description="The vendor selected product identification of the item. Should be the same as was provided in the purchase order.")
    public String getVendorProductIdentifier() {
        return this.vendorProductIdentifier;
    }

    public void setVendorProductIdentifier(String vendorProductIdentifier) {
        this.vendorProductIdentifier = vendorProductIdentifier;
    }

    public OrderItemAcknowledgement acknowledgedQuantity(ItemQuantity acknowledgedQuantity) {
        this.acknowledgedQuantity = acknowledgedQuantity;
        return this;
    }

    @Schema(required=true, description="")
    public ItemQuantity getAcknowledgedQuantity() {
        return this.acknowledgedQuantity;
    }

    public void setAcknowledgedQuantity(ItemQuantity acknowledgedQuantity) {
        this.acknowledgedQuantity = acknowledgedQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemAcknowledgement orderItemAcknowledgement = (OrderItemAcknowledgement)o;
        return Objects.equals(this.itemSequenceNumber, orderItemAcknowledgement.itemSequenceNumber) && Objects.equals(this.buyerProductIdentifier, orderItemAcknowledgement.buyerProductIdentifier) && Objects.equals(this.vendorProductIdentifier, orderItemAcknowledgement.vendorProductIdentifier) && Objects.equals(this.acknowledgedQuantity, orderItemAcknowledgement.acknowledgedQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.itemSequenceNumber, this.buyerProductIdentifier, this.vendorProductIdentifier, this.acknowledgedQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemAcknowledgement {\n");
        sb.append("    itemSequenceNumber: ").append(this.toIndentedString(this.itemSequenceNumber)).append("\n");
        sb.append("    buyerProductIdentifier: ").append(this.toIndentedString(this.buyerProductIdentifier)).append("\n");
        sb.append("    vendorProductIdentifier: ").append(this.toIndentedString(this.vendorProductIdentifier)).append("\n");
        sb.append("    acknowledgedQuantity: ").append(this.toIndentedString(this.acknowledgedQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

