/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.orders.v2021_12_28;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.AcknowledgementStatus;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.OrderItemAcknowledgement;
import software.amazon.spapi.models.vendor.df.orders.v2021_12_28.PartyIdentification;

@Schema(description="Details of an individual order being acknowledged.")
public class OrderAcknowledgementItem {
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber = null;
    @SerializedName(value="vendorOrderNumber")
    private String vendorOrderNumber = null;
    @SerializedName(value="acknowledgementDate")
    private OffsetDateTime acknowledgementDate = null;
    @SerializedName(value="acknowledgementStatus")
    private AcknowledgementStatus acknowledgementStatus = null;
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="shipFromParty")
    private PartyIdentification shipFromParty = null;
    @SerializedName(value="itemAcknowledgements")
    private List<OrderItemAcknowledgement> itemAcknowledgements = new ArrayList<OrderItemAcknowledgement>();

    public OrderAcknowledgementItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Schema(required=true, description="The purchase order number for this order. Formatting Notes: alpha-numeric code.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public OrderAcknowledgementItem vendorOrderNumber(String vendorOrderNumber) {
        this.vendorOrderNumber = vendorOrderNumber;
        return this;
    }

    @Schema(required=true, description="The vendor's order number for this order.")
    public String getVendorOrderNumber() {
        return this.vendorOrderNumber;
    }

    public void setVendorOrderNumber(String vendorOrderNumber) {
        this.vendorOrderNumber = vendorOrderNumber;
    }

    public OrderAcknowledgementItem acknowledgementDate(OffsetDateTime acknowledgementDate) {
        this.acknowledgementDate = acknowledgementDate;
        return this;
    }

    @Schema(required=true, description="The date and time when the order is acknowledged, in ISO-8601 date/time format. For example: 2018-07-16T23:00:00Z / 2018-07-16T23:00:00-05:00 / 2018-07-16T23:00:00-08:00.")
    public OffsetDateTime getAcknowledgementDate() {
        return this.acknowledgementDate;
    }

    public void setAcknowledgementDate(OffsetDateTime acknowledgementDate) {
        this.acknowledgementDate = acknowledgementDate;
    }

    public OrderAcknowledgementItem acknowledgementStatus(AcknowledgementStatus acknowledgementStatus) {
        this.acknowledgementStatus = acknowledgementStatus;
        return this;
    }

    @Schema(required=true, description="")
    public AcknowledgementStatus getAcknowledgementStatus() {
        return this.acknowledgementStatus;
    }

    public void setAcknowledgementStatus(AcknowledgementStatus acknowledgementStatus) {
        this.acknowledgementStatus = acknowledgementStatus;
    }

    public OrderAcknowledgementItem sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public OrderAcknowledgementItem shipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getShipFromParty() {
        return this.shipFromParty;
    }

    public void setShipFromParty(PartyIdentification shipFromParty) {
        this.shipFromParty = shipFromParty;
    }

    public OrderAcknowledgementItem itemAcknowledgements(List<OrderItemAcknowledgement> itemAcknowledgements) {
        this.itemAcknowledgements = itemAcknowledgements;
        return this;
    }

    public OrderAcknowledgementItem addItemAcknowledgementsItem(OrderItemAcknowledgement itemAcknowledgementsItem) {
        this.itemAcknowledgements.add(itemAcknowledgementsItem);
        return this;
    }

    @Schema(required=true, description="Item details including acknowledged quantity.")
    public List<OrderItemAcknowledgement> getItemAcknowledgements() {
        return this.itemAcknowledgements;
    }

    public void setItemAcknowledgements(List<OrderItemAcknowledgement> itemAcknowledgements) {
        this.itemAcknowledgements = itemAcknowledgements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderAcknowledgementItem orderAcknowledgementItem = (OrderAcknowledgementItem)o;
        return Objects.equals(this.purchaseOrderNumber, orderAcknowledgementItem.purchaseOrderNumber) && Objects.equals(this.vendorOrderNumber, orderAcknowledgementItem.vendorOrderNumber) && Objects.equals(this.acknowledgementDate, orderAcknowledgementItem.acknowledgementDate) && Objects.equals(this.acknowledgementStatus, orderAcknowledgementItem.acknowledgementStatus) && Objects.equals(this.sellingParty, orderAcknowledgementItem.sellingParty) && Objects.equals(this.shipFromParty, orderAcknowledgementItem.shipFromParty) && Objects.equals(this.itemAcknowledgements, orderAcknowledgementItem.itemAcknowledgements);
    }

    public int hashCode() {
        return Objects.hash(this.purchaseOrderNumber, this.vendorOrderNumber, this.acknowledgementDate, this.acknowledgementStatus, this.sellingParty, this.shipFromParty, this.itemAcknowledgements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAcknowledgementItem {\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    vendorOrderNumber: ").append(this.toIndentedString(this.vendorOrderNumber)).append("\n");
        sb.append("    acknowledgementDate: ").append(this.toIndentedString(this.acknowledgementDate)).append("\n");
        sb.append("    acknowledgementStatus: ").append(this.toIndentedString(this.acknowledgementStatus)).append("\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    shipFromParty: ").append(this.toIndentedString(this.shipFromParty)).append("\n");
        sb.append("    itemAcknowledgements: ").append(this.toIndentedString(this.itemAcknowledgements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

