/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vendor.df.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vendor.df.inventory.v1.ItemDetails;
import software.amazon.spapi.models.vendor.df.inventory.v1.PartyIdentification;

@Schema(description="Inventory details required to update some or all items for the requested warehouse.")
public class InventoryUpdate {
    @SerializedName(value="sellingParty")
    private PartyIdentification sellingParty = null;
    @SerializedName(value="isFullUpdate")
    private Boolean isFullUpdate = null;
    @SerializedName(value="items")
    private List<ItemDetails> items = new ArrayList<ItemDetails>();

    public InventoryUpdate sellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
        return this;
    }

    @Schema(required=true, description="")
    public PartyIdentification getSellingParty() {
        return this.sellingParty;
    }

    public void setSellingParty(PartyIdentification sellingParty) {
        this.sellingParty = sellingParty;
    }

    public InventoryUpdate isFullUpdate(Boolean isFullUpdate) {
        this.isFullUpdate = isFullUpdate;
        return this;
    }

    @Schema(required=true, description="When true, this request contains a full feed. Otherwise, this request contains a partial feed. When sending a full feed, you must send information about all items in the warehouse. Any items not in the full feed are updated as not available. When sending a partial feed, only include the items that need an update to inventory. The status of other items will remain unchanged.")
    public Boolean isIsFullUpdate() {
        return this.isFullUpdate;
    }

    public void setIsFullUpdate(Boolean isFullUpdate) {
        this.isFullUpdate = isFullUpdate;
    }

    public InventoryUpdate items(List<ItemDetails> items) {
        this.items = items;
        return this;
    }

    public InventoryUpdate addItemsItem(ItemDetails itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="A list of inventory items with updated details, including quantity available.")
    public List<ItemDetails> getItems() {
        return this.items;
    }

    public void setItems(List<ItemDetails> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryUpdate inventoryUpdate = (InventoryUpdate)o;
        return Objects.equals(this.sellingParty, inventoryUpdate.sellingParty) && Objects.equals(this.isFullUpdate, inventoryUpdate.isFullUpdate) && Objects.equals(this.items, inventoryUpdate.items);
    }

    public int hashCode() {
        return Objects.hash(this.sellingParty, this.isFullUpdate, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryUpdate {\n");
        sb.append("    sellingParty: ").append(this.toIndentedString(this.sellingParty)).append("\n");
        sb.append("    isFullUpdate: ").append(this.toIndentedString(this.isFullUpdate)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

