/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.vehicles.v2024_11_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.vehicles.v2024_11_01.EngineOutput;
import software.amazon.spapi.models.vehicles.v2024_11_01.MonthAndYear;
import software.amazon.spapi.models.vehicles.v2024_11_01.VehicleIdentifiers;
import software.amazon.spapi.models.vehicles.v2024_11_01.VehicleStatusInCatalog;

@Schema(description="Combinations of attributes and unique identifier that represents a vehicle in vehicle list.")
public class Vehicle {
    @SerializedName(value="make")
    private String make = null;
    @SerializedName(value="model")
    private String model = null;
    @SerializedName(value="variantName")
    private String variantName = null;
    @SerializedName(value="bodyStyle")
    private String bodyStyle = null;
    @SerializedName(value="driveType")
    private String driveType = null;
    @SerializedName(value="energy")
    private String energy = null;
    @SerializedName(value="engineOutput")
    private List<EngineOutput> engineOutput = null;
    @SerializedName(value="manufacturingStartDate")
    private MonthAndYear manufacturingStartDate = null;
    @SerializedName(value="manufacturingStopDate")
    private MonthAndYear manufacturingStopDate = null;
    @SerializedName(value="lastProcessedDate")
    private String lastProcessedDate = null;
    @SerializedName(value="status")
    private VehicleStatusInCatalog status = null;
    @SerializedName(value="identifiers")
    private List<VehicleIdentifiers> identifiers = new ArrayList<VehicleIdentifiers>();

    public Vehicle make(String make) {
        this.make = make;
        return this;
    }

    @Schema(required=true, description="Vehicle Brand.")
    public String getMake() {
        return this.make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public Vehicle model(String model) {
        this.model = model;
        return this;
    }

    @Schema(required=true, description="Specific model of a vehicle.")
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Vehicle variantName(String variantName) {
        this.variantName = variantName;
        return this;
    }

    @Schema(description="Name of the vehicle variant.")
    public String getVariantName() {
        return this.variantName;
    }

    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    public Vehicle bodyStyle(String bodyStyle) {
        this.bodyStyle = bodyStyle;
        return this;
    }

    @Schema(description="Body style of vehicle (example: Hatchback, Cabriolet).")
    public String getBodyStyle() {
        return this.bodyStyle;
    }

    public void setBodyStyle(String bodyStyle) {
        this.bodyStyle = bodyStyle;
    }

    public Vehicle driveType(String driveType) {
        this.driveType = driveType;
        return this;
    }

    @Schema(description="Drive type of vehicle(example: Rear wheel drive).")
    public String getDriveType() {
        return this.driveType;
    }

    public void setDriveType(String driveType) {
        this.driveType = driveType;
    }

    public Vehicle energy(String energy) {
        this.energy = energy;
        return this;
    }

    @Schema(description="Energy Source for the vehicle(example: Petrol)")
    public String getEnergy() {
        return this.energy;
    }

    public void setEnergy(String energy) {
        this.energy = energy;
    }

    public Vehicle engineOutput(List<EngineOutput> engineOutput) {
        this.engineOutput = engineOutput;
        return this;
    }

    public Vehicle addEngineOutputItem(EngineOutput engineOutputItem) {
        if (this.engineOutput == null) {
            this.engineOutput = new ArrayList<EngineOutput>();
        }
        this.engineOutput.add(engineOutputItem);
        return this;
    }

    @Schema(description="Engine output of vehicle.")
    public List<EngineOutput> getEngineOutput() {
        return this.engineOutput;
    }

    public void setEngineOutput(List<EngineOutput> engineOutput) {
        this.engineOutput = engineOutput;
    }

    public Vehicle manufacturingStartDate(MonthAndYear manufacturingStartDate) {
        this.manufacturingStartDate = manufacturingStartDate;
        return this;
    }

    @Schema(description="")
    public MonthAndYear getManufacturingStartDate() {
        return this.manufacturingStartDate;
    }

    public void setManufacturingStartDate(MonthAndYear manufacturingStartDate) {
        this.manufacturingStartDate = manufacturingStartDate;
    }

    public Vehicle manufacturingStopDate(MonthAndYear manufacturingStopDate) {
        this.manufacturingStopDate = manufacturingStopDate;
        return this;
    }

    @Schema(description="")
    public MonthAndYear getManufacturingStopDate() {
        return this.manufacturingStopDate;
    }

    public void setManufacturingStopDate(MonthAndYear manufacturingStopDate) {
        this.manufacturingStopDate = manufacturingStopDate;
    }

    public Vehicle lastProcessedDate(String lastProcessedDate) {
        this.lastProcessedDate = lastProcessedDate;
        return this;
    }

    @Schema(description="The date on which the vehicle was last updated, in ISO-8601 date/time format.")
    public String getLastProcessedDate() {
        return this.lastProcessedDate;
    }

    public void setLastProcessedDate(String lastProcessedDate) {
        this.lastProcessedDate = lastProcessedDate;
    }

    public Vehicle status(VehicleStatusInCatalog status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    public VehicleStatusInCatalog getStatus() {
        return this.status;
    }

    public void setStatus(VehicleStatusInCatalog status) {
        this.status = status;
    }

    public Vehicle identifiers(List<VehicleIdentifiers> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public Vehicle addIdentifiersItem(VehicleIdentifiers identifiersItem) {
        this.identifiers.add(identifiersItem);
        return this;
    }

    @Schema(required=true, description="Identifiers that can be used to identify the vehicle uniquely")
    public List<VehicleIdentifiers> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<VehicleIdentifiers> identifiers) {
        this.identifiers = identifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vehicle vehicle = (Vehicle)o;
        return Objects.equals(this.make, vehicle.make) && Objects.equals(this.model, vehicle.model) && Objects.equals(this.variantName, vehicle.variantName) && Objects.equals(this.bodyStyle, vehicle.bodyStyle) && Objects.equals(this.driveType, vehicle.driveType) && Objects.equals(this.energy, vehicle.energy) && Objects.equals(this.engineOutput, vehicle.engineOutput) && Objects.equals(this.manufacturingStartDate, vehicle.manufacturingStartDate) && Objects.equals(this.manufacturingStopDate, vehicle.manufacturingStopDate) && Objects.equals(this.lastProcessedDate, vehicle.lastProcessedDate) && Objects.equals((Object)this.status, (Object)vehicle.status) && Objects.equals(this.identifiers, vehicle.identifiers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.make, this.model, this.variantName, this.bodyStyle, this.driveType, this.energy, this.engineOutput, this.manufacturingStartDate, this.manufacturingStopDate, this.lastProcessedDate, this.status, this.identifiers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vehicle {\n");
        sb.append("    make: ").append(this.toIndentedString(this.make)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    variantName: ").append(this.toIndentedString(this.variantName)).append("\n");
        sb.append("    bodyStyle: ").append(this.toIndentedString(this.bodyStyle)).append("\n");
        sb.append("    driveType: ").append(this.toIndentedString(this.driveType)).append("\n");
        sb.append("    energy: ").append(this.toIndentedString(this.energy)).append("\n");
        sb.append("    engineOutput: ").append(this.toIndentedString(this.engineOutput)).append("\n");
        sb.append("    manufacturingStartDate: ").append(this.toIndentedString(this.manufacturingStartDate)).append("\n");
        sb.append("    manufacturingStopDate: ").append(this.toIndentedString(this.manufacturingStopDate)).append("\n");
        sb.append("    lastProcessedDate: ").append(this.toIndentedString(this.lastProcessedDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

