/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.transfers.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.transfers.v2024_06_01.AssignmentType;
import software.amazon.spapi.models.transfers.v2024_06_01.ExpiryDate;
import software.amazon.spapi.models.transfers.v2024_06_01.PaymentMethodType;

@Schema(description="The details of a payment method.")
public class PaymentMethodDetails {
    @SerializedName(value="accountHolderName")
    private String accountHolderName = null;
    @SerializedName(value="paymentMethodId")
    private String paymentMethodId = null;
    @SerializedName(value="tail")
    private String tail = null;
    @SerializedName(value="expiryDate")
    private ExpiryDate expiryDate = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="paymentMethodType")
    private PaymentMethodType paymentMethodType = null;
    @SerializedName(value="assignmentType")
    private AssignmentType assignmentType = null;

    public PaymentMethodDetails accountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
        return this;
    }

    @Schema(description="The name of the account holder who is registered for the payment method.")
    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public PaymentMethodDetails paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Schema(example="0h_TU_CUS_4058fe2a-da6b-4b82-8e48-b20ff2eb4f6d", description="The payment method identifier.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentMethodDetails tail(String tail) {
        this.tail = tail;
        return this;
    }

    @Schema(example="321", description="The last three or four digits of the payment method.")
    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public PaymentMethodDetails expiryDate(ExpiryDate expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Schema(description="")
    public ExpiryDate getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(ExpiryDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    public PaymentMethodDetails countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(example="US", description="The two-letter country code in ISO 3166-1 alpha-2 format. For payment methods in the `card` category, the code is for the country where the card was issued. For payment methods in the `bank account` category, the code is for the country where the account is located.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentMethodDetails paymentMethodType(PaymentMethodType paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @Schema(description="")
    public PaymentMethodType getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(PaymentMethodType paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public PaymentMethodDetails assignmentType(AssignmentType assignmentType) {
        this.assignmentType = assignmentType;
        return this;
    }

    @Schema(description="")
    public AssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public void setAssignmentType(AssignmentType assignmentType) {
        this.assignmentType = assignmentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodDetails paymentMethodDetails = (PaymentMethodDetails)o;
        return Objects.equals(this.accountHolderName, paymentMethodDetails.accountHolderName) && Objects.equals(this.paymentMethodId, paymentMethodDetails.paymentMethodId) && Objects.equals(this.tail, paymentMethodDetails.tail) && Objects.equals(this.expiryDate, paymentMethodDetails.expiryDate) && Objects.equals(this.countryCode, paymentMethodDetails.countryCode) && Objects.equals((Object)this.paymentMethodType, (Object)paymentMethodDetails.paymentMethodType) && Objects.equals((Object)this.assignmentType, (Object)paymentMethodDetails.assignmentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderName, this.paymentMethodId, this.tail, this.expiryDate, this.countryCode, this.paymentMethodType, this.assignmentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodDetails {\n");
        sb.append("    accountHolderName: ").append(this.toIndentedString(this.accountHolderName)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    tail: ").append(this.toIndentedString(this.tail)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString((Object)this.paymentMethodType)).append("\n");
        sb.append("    assignmentType: ").append(this.toIndentedString((Object)this.assignmentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

