/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.tokens.v2021_03_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Model of a restricted resource.")
public class RestrictedResource {
    @SerializedName(value="method")
    private MethodEnum method = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="dataElements")
    private List<String> dataElements = null;

    public RestrictedResource method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Schema(required=true, description="The HTTP method in the restricted resource.")
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public RestrictedResource path(String path) {
        this.path = path;
        return this;
    }

    @Schema(required=true, description="The path in the restricted resource. Here are some path examples: - ```/orders/v0/orders```. For getting an RDT for the getOrders operation of the Orders API. For bulk orders. - ```/orders/v0/orders/123-1234567-1234567```. For getting an RDT for the getOrder operation of the Orders API. For a specific order. - ```/orders/v0/orders/123-1234567-1234567/orderItems```. For getting an RDT for the getOrderItems operation of the Orders API. For the order items in a specific order. - ```/mfn/v0/shipments/FBA1234ABC5D```. For getting an RDT for the getShipment operation of the Shipping API. For a specific shipment. - ```/mfn/v0/shipments/{shipmentId}```. For getting an RDT for the getShipment operation of the Shipping API. For any of a selling partner's shipments that you specify when you call the getShipment operation.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RestrictedResource dataElements(List<String> dataElements) {
        this.dataElements = dataElements;
        return this;
    }

    public RestrictedResource addDataElementsItem(String dataElementsItem) {
        if (this.dataElements == null) {
            this.dataElements = new ArrayList<String>();
        }
        this.dataElements.add(dataElementsItem);
        return this;
    }

    @Schema(description="Indicates the type of Personally Identifiable Information requested. This parameter is required only when getting an RDT for use with the getOrder, getOrders, or getOrderItems operation of the Orders API. For more information, see the [Tokens API Use Case Guide](doc:tokens-api-use-case-guide). Possible values include: - **buyerInfo**. On the order level this includes general identifying information about the buyer and tax-related information. On the order item level this includes gift wrap information and custom order information, if available. - **shippingAddress**. This includes information for fulfilling orders. - **buyerTaxInformation**. This includes information for issuing tax invoices.")
    public List<String> getDataElements() {
        return this.dataElements;
    }

    public void setDataElements(List<String> dataElements) {
        this.dataElements = dataElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedResource restrictedResource = (RestrictedResource)o;
        return Objects.equals((Object)this.method, (Object)restrictedResource.method) && Objects.equals(this.path, restrictedResource.path) && Objects.equals(this.dataElements, restrictedResource.dataElements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.path, this.dataElements});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestrictedResource {\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    dataElements: ").append(this.toIndentedString(this.dataElements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        GET("GET"),
        PUT("PUT"),
        POST("POST"),
        DELETE("DELETE");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String input) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(value);
            }
        }
    }
}

