/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.RequestedDocumentSpecification;
import software.amazon.spapi.models.shipping.v2.RequestedValueAddedServiceList;

@Schema(description="The request schema for the purchaseShipment operation.")
public class PurchaseShipmentRequest {
    @SerializedName(value="requestToken")
    private String requestToken = null;
    @SerializedName(value="rateId")
    private String rateId = null;
    @SerializedName(value="requestedDocumentSpecification")
    private RequestedDocumentSpecification requestedDocumentSpecification = null;
    @SerializedName(value="requestedValueAddedServices")
    private RequestedValueAddedServiceList requestedValueAddedServices = null;
    @SerializedName(value="additionalInputs")
    private Map<String, Object> additionalInputs = null;

    public PurchaseShipmentRequest requestToken(String requestToken) {
        this.requestToken = requestToken;
        return this;
    }

    @Schema(required=true, description="")
    public String getRequestToken() {
        return this.requestToken;
    }

    public void setRequestToken(String requestToken) {
        this.requestToken = requestToken;
    }

    public PurchaseShipmentRequest rateId(String rateId) {
        this.rateId = rateId;
        return this;
    }

    @Schema(required=true, description="")
    public String getRateId() {
        return this.rateId;
    }

    public void setRateId(String rateId) {
        this.rateId = rateId;
    }

    public PurchaseShipmentRequest requestedDocumentSpecification(RequestedDocumentSpecification requestedDocumentSpecification) {
        this.requestedDocumentSpecification = requestedDocumentSpecification;
        return this;
    }

    @Schema(required=true, description="")
    public RequestedDocumentSpecification getRequestedDocumentSpecification() {
        return this.requestedDocumentSpecification;
    }

    public void setRequestedDocumentSpecification(RequestedDocumentSpecification requestedDocumentSpecification) {
        this.requestedDocumentSpecification = requestedDocumentSpecification;
    }

    public PurchaseShipmentRequest requestedValueAddedServices(RequestedValueAddedServiceList requestedValueAddedServices) {
        this.requestedValueAddedServices = requestedValueAddedServices;
        return this;
    }

    @Schema(description="")
    public RequestedValueAddedServiceList getRequestedValueAddedServices() {
        return this.requestedValueAddedServices;
    }

    public void setRequestedValueAddedServices(RequestedValueAddedServiceList requestedValueAddedServices) {
        this.requestedValueAddedServices = requestedValueAddedServices;
    }

    public PurchaseShipmentRequest additionalInputs(Map<String, Object> additionalInputs) {
        this.additionalInputs = additionalInputs;
        return this;
    }

    public PurchaseShipmentRequest putAdditionalInputsItem(String key, Object additionalInputsItem) {
        if (this.additionalInputs == null) {
            this.additionalInputs = new HashMap<String, Object>();
        }
        this.additionalInputs.put(key, additionalInputsItem);
        return this;
    }

    @Schema(description="The additional inputs required to purchase a shipping offering, in JSON format. The JSON provided here must adhere to the JSON schema that is returned in the response to the getAdditionalInputs operation.  Additional inputs are only required when indicated by the requiresAdditionalInputs property in the response to the getRates operation.")
    public Map<String, Object> getAdditionalInputs() {
        return this.additionalInputs;
    }

    public void setAdditionalInputs(Map<String, Object> additionalInputs) {
        this.additionalInputs = additionalInputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchaseShipmentRequest purchaseShipmentRequest = (PurchaseShipmentRequest)o;
        return Objects.equals(this.requestToken, purchaseShipmentRequest.requestToken) && Objects.equals(this.rateId, purchaseShipmentRequest.rateId) && Objects.equals(this.requestedDocumentSpecification, purchaseShipmentRequest.requestedDocumentSpecification) && Objects.equals(this.requestedValueAddedServices, purchaseShipmentRequest.requestedValueAddedServices) && Objects.equals(this.additionalInputs, purchaseShipmentRequest.additionalInputs);
    }

    public int hashCode() {
        return Objects.hash(this.requestToken, this.rateId, this.requestedDocumentSpecification, this.requestedValueAddedServices, this.additionalInputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PurchaseShipmentRequest {\n");
        sb.append("    requestToken: ").append(this.toIndentedString(this.requestToken)).append("\n");
        sb.append("    rateId: ").append(this.toIndentedString(this.rateId)).append("\n");
        sb.append("    requestedDocumentSpecification: ").append(this.toIndentedString(this.requestedDocumentSpecification)).append("\n");
        sb.append("    requestedValueAddedServices: ").append(this.toIndentedString(this.requestedValueAddedServices)).append("\n");
        sb.append("    additionalInputs: ").append(this.toIndentedString(this.additionalInputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

