/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.shipping.v2.AccessPointDetails;
import software.amazon.spapi.models.shipping.v2.Address;
import software.amazon.spapi.models.shipping.v2.CarrierAccounts;
import software.amazon.spapi.models.shipping.v2.ChannelDetails;
import software.amazon.spapi.models.shipping.v2.ClientReferenceDetails;
import software.amazon.spapi.models.shipping.v2.PackageList;
import software.amazon.spapi.models.shipping.v2.ShipmentType;
import software.amazon.spapi.models.shipping.v2.ShipperInstruction;
import software.amazon.spapi.models.shipping.v2.TaxDetailList;
import software.amazon.spapi.models.shipping.v2.ValueAddedServiceDetails;

@Schema(description="The request schema for the getRates operation. When the channelType is Amazon, the shipTo address is not required and will be ignored.")
public class GetRatesRequest {
    @SerializedName(value="shipTo")
    private Address shipTo = null;
    @SerializedName(value="shipFrom")
    private Address shipFrom = null;
    @SerializedName(value="returnTo")
    private Address returnTo = null;
    @SerializedName(value="shipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="shipperInstruction")
    private ShipperInstruction shipperInstruction = null;
    @SerializedName(value="packages")
    private PackageList packages = null;
    @SerializedName(value="valueAddedServices")
    private ValueAddedServiceDetails valueAddedServices = null;
    @SerializedName(value="taxDetails")
    private TaxDetailList taxDetails = null;
    @SerializedName(value="channelDetails")
    private ChannelDetails channelDetails = null;
    @SerializedName(value="clientReferenceDetails")
    private ClientReferenceDetails clientReferenceDetails = null;
    @SerializedName(value="shipmentType")
    private ShipmentType shipmentType = null;
    @SerializedName(value="destinationAccessPointDetails")
    private AccessPointDetails destinationAccessPointDetails = null;
    @SerializedName(value="carrierAccounts")
    private CarrierAccounts carrierAccounts = null;

    public GetRatesRequest shipTo(Address shipTo) {
        this.shipTo = shipTo;
        return this;
    }

    @Schema(description="")
    public Address getShipTo() {
        return this.shipTo;
    }

    public void setShipTo(Address shipTo) {
        this.shipTo = shipTo;
    }

    public GetRatesRequest shipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @Schema(required=true, description="")
    public Address getShipFrom() {
        return this.shipFrom;
    }

    public void setShipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
    }

    public GetRatesRequest returnTo(Address returnTo) {
        this.returnTo = returnTo;
        return this;
    }

    @Schema(description="")
    public Address getReturnTo() {
        return this.returnTo;
    }

    public void setReturnTo(Address returnTo) {
        this.returnTo = returnTo;
    }

    public GetRatesRequest shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @Schema(description="The ship date and time (the requested pickup). This defaults to the current date and time.")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public GetRatesRequest shipperInstruction(ShipperInstruction shipperInstruction) {
        this.shipperInstruction = shipperInstruction;
        return this;
    }

    @Schema(description="")
    public ShipperInstruction getShipperInstruction() {
        return this.shipperInstruction;
    }

    public void setShipperInstruction(ShipperInstruction shipperInstruction) {
        this.shipperInstruction = shipperInstruction;
    }

    public GetRatesRequest packages(PackageList packages) {
        this.packages = packages;
        return this;
    }

    @Schema(required=true, description="")
    public PackageList getPackages() {
        return this.packages;
    }

    public void setPackages(PackageList packages) {
        this.packages = packages;
    }

    public GetRatesRequest valueAddedServices(ValueAddedServiceDetails valueAddedServices) {
        this.valueAddedServices = valueAddedServices;
        return this;
    }

    @Schema(description="")
    public ValueAddedServiceDetails getValueAddedServices() {
        return this.valueAddedServices;
    }

    public void setValueAddedServices(ValueAddedServiceDetails valueAddedServices) {
        this.valueAddedServices = valueAddedServices;
    }

    public GetRatesRequest taxDetails(TaxDetailList taxDetails) {
        this.taxDetails = taxDetails;
        return this;
    }

    @Schema(description="")
    public TaxDetailList getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(TaxDetailList taxDetails) {
        this.taxDetails = taxDetails;
    }

    public GetRatesRequest channelDetails(ChannelDetails channelDetails) {
        this.channelDetails = channelDetails;
        return this;
    }

    @Schema(required=true, description="")
    public ChannelDetails getChannelDetails() {
        return this.channelDetails;
    }

    public void setChannelDetails(ChannelDetails channelDetails) {
        this.channelDetails = channelDetails;
    }

    public GetRatesRequest clientReferenceDetails(ClientReferenceDetails clientReferenceDetails) {
        this.clientReferenceDetails = clientReferenceDetails;
        return this;
    }

    @Schema(description="")
    public ClientReferenceDetails getClientReferenceDetails() {
        return this.clientReferenceDetails;
    }

    public void setClientReferenceDetails(ClientReferenceDetails clientReferenceDetails) {
        this.clientReferenceDetails = clientReferenceDetails;
    }

    public GetRatesRequest shipmentType(ShipmentType shipmentType) {
        this.shipmentType = shipmentType;
        return this;
    }

    @Schema(description="")
    public ShipmentType getShipmentType() {
        return this.shipmentType;
    }

    public void setShipmentType(ShipmentType shipmentType) {
        this.shipmentType = shipmentType;
    }

    public GetRatesRequest destinationAccessPointDetails(AccessPointDetails destinationAccessPointDetails) {
        this.destinationAccessPointDetails = destinationAccessPointDetails;
        return this;
    }

    @Schema(description="")
    public AccessPointDetails getDestinationAccessPointDetails() {
        return this.destinationAccessPointDetails;
    }

    public void setDestinationAccessPointDetails(AccessPointDetails destinationAccessPointDetails) {
        this.destinationAccessPointDetails = destinationAccessPointDetails;
    }

    public GetRatesRequest carrierAccounts(CarrierAccounts carrierAccounts) {
        this.carrierAccounts = carrierAccounts;
        return this;
    }

    @Schema(description="")
    public CarrierAccounts getCarrierAccounts() {
        return this.carrierAccounts;
    }

    public void setCarrierAccounts(CarrierAccounts carrierAccounts) {
        this.carrierAccounts = carrierAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRatesRequest getRatesRequest = (GetRatesRequest)o;
        return Objects.equals(this.shipTo, getRatesRequest.shipTo) && Objects.equals(this.shipFrom, getRatesRequest.shipFrom) && Objects.equals(this.returnTo, getRatesRequest.returnTo) && Objects.equals(this.shipDate, getRatesRequest.shipDate) && Objects.equals(this.shipperInstruction, getRatesRequest.shipperInstruction) && Objects.equals(this.packages, getRatesRequest.packages) && Objects.equals(this.valueAddedServices, getRatesRequest.valueAddedServices) && Objects.equals(this.taxDetails, getRatesRequest.taxDetails) && Objects.equals(this.channelDetails, getRatesRequest.channelDetails) && Objects.equals(this.clientReferenceDetails, getRatesRequest.clientReferenceDetails) && Objects.equals((Object)this.shipmentType, (Object)getRatesRequest.shipmentType) && Objects.equals(this.destinationAccessPointDetails, getRatesRequest.destinationAccessPointDetails) && Objects.equals(this.carrierAccounts, getRatesRequest.carrierAccounts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipTo, this.shipFrom, this.returnTo, this.shipDate, this.shipperInstruction, this.packages, this.valueAddedServices, this.taxDetails, this.channelDetails, this.clientReferenceDetails, this.shipmentType, this.destinationAccessPointDetails, this.carrierAccounts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetRatesRequest {\n");
        sb.append("    shipTo: ").append(this.toIndentedString(this.shipTo)).append("\n");
        sb.append("    shipFrom: ").append(this.toIndentedString(this.shipFrom)).append("\n");
        sb.append("    returnTo: ").append(this.toIndentedString(this.returnTo)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    shipperInstruction: ").append(this.toIndentedString(this.shipperInstruction)).append("\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("    valueAddedServices: ").append(this.toIndentedString(this.valueAddedServices)).append("\n");
        sb.append("    taxDetails: ").append(this.toIndentedString(this.taxDetails)).append("\n");
        sb.append("    channelDetails: ").append(this.toIndentedString(this.channelDetails)).append("\n");
        sb.append("    clientReferenceDetails: ").append(this.toIndentedString(this.clientReferenceDetails)).append("\n");
        sb.append("    shipmentType: ").append(this.toIndentedString((Object)this.shipmentType)).append("\n");
        sb.append("    destinationAccessPointDetails: ").append(this.toIndentedString(this.destinationAccessPointDetails)).append("\n");
        sb.append("    carrierAccounts: ").append(this.toIndentedString(this.carrierAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

