/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.Address;
import software.amazon.spapi.models.shipping.v2.ChannelDetails;
import software.amazon.spapi.models.shipping.v2.PackageList;
import software.amazon.spapi.models.shipping.v2.RequestedDocumentSpecification;

@Schema(description="The request schema for the directPurchaseShipment operation. When the channel type is Amazon, the shipTo address is not required and will be ignored.")
public class DirectPurchaseRequest {
    @SerializedName(value="shipTo")
    private Address shipTo = null;
    @SerializedName(value="shipFrom")
    private Address shipFrom = null;
    @SerializedName(value="returnTo")
    private Address returnTo = null;
    @SerializedName(value="packages")
    private PackageList packages = null;
    @SerializedName(value="channelDetails")
    private ChannelDetails channelDetails = null;
    @SerializedName(value="labelSpecifications")
    private RequestedDocumentSpecification labelSpecifications = null;

    public DirectPurchaseRequest shipTo(Address shipTo) {
        this.shipTo = shipTo;
        return this;
    }

    @Schema(description="")
    public Address getShipTo() {
        return this.shipTo;
    }

    public void setShipTo(Address shipTo) {
        this.shipTo = shipTo;
    }

    public DirectPurchaseRequest shipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
        return this;
    }

    @Schema(description="")
    public Address getShipFrom() {
        return this.shipFrom;
    }

    public void setShipFrom(Address shipFrom) {
        this.shipFrom = shipFrom;
    }

    public DirectPurchaseRequest returnTo(Address returnTo) {
        this.returnTo = returnTo;
        return this;
    }

    @Schema(description="")
    public Address getReturnTo() {
        return this.returnTo;
    }

    public void setReturnTo(Address returnTo) {
        this.returnTo = returnTo;
    }

    public DirectPurchaseRequest packages(PackageList packages) {
        this.packages = packages;
        return this;
    }

    @Schema(description="")
    public PackageList getPackages() {
        return this.packages;
    }

    public void setPackages(PackageList packages) {
        this.packages = packages;
    }

    public DirectPurchaseRequest channelDetails(ChannelDetails channelDetails) {
        this.channelDetails = channelDetails;
        return this;
    }

    @Schema(required=true, description="")
    public ChannelDetails getChannelDetails() {
        return this.channelDetails;
    }

    public void setChannelDetails(ChannelDetails channelDetails) {
        this.channelDetails = channelDetails;
    }

    public DirectPurchaseRequest labelSpecifications(RequestedDocumentSpecification labelSpecifications) {
        this.labelSpecifications = labelSpecifications;
        return this;
    }

    @Schema(description="")
    public RequestedDocumentSpecification getLabelSpecifications() {
        return this.labelSpecifications;
    }

    public void setLabelSpecifications(RequestedDocumentSpecification labelSpecifications) {
        this.labelSpecifications = labelSpecifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectPurchaseRequest directPurchaseRequest = (DirectPurchaseRequest)o;
        return Objects.equals(this.shipTo, directPurchaseRequest.shipTo) && Objects.equals(this.shipFrom, directPurchaseRequest.shipFrom) && Objects.equals(this.returnTo, directPurchaseRequest.returnTo) && Objects.equals(this.packages, directPurchaseRequest.packages) && Objects.equals(this.channelDetails, directPurchaseRequest.channelDetails) && Objects.equals(this.labelSpecifications, directPurchaseRequest.labelSpecifications);
    }

    public int hashCode() {
        return Objects.hash(this.shipTo, this.shipFrom, this.returnTo, this.packages, this.channelDetails, this.labelSpecifications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectPurchaseRequest {\n");
        sb.append("    shipTo: ").append(this.toIndentedString(this.shipTo)).append("\n");
        sb.append("    shipFrom: ").append(this.toIndentedString(this.shipFrom)).append("\n");
        sb.append("    returnTo: ").append(this.toIndentedString(this.returnTo)).append("\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("    channelDetails: ").append(this.toIndentedString(this.channelDetails)).append("\n");
        sb.append("    labelSpecifications: ").append(this.toIndentedString(this.labelSpecifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

