/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Item identifiers for an item in a direct fulfillment shipment.")
public class DirectFulfillmentItemIdentifiers {
    @SerializedName(value="lineItemID")
    private String lineItemID = null;
    @SerializedName(value="pieceNumber")
    private String pieceNumber = null;

    public DirectFulfillmentItemIdentifiers lineItemID(String lineItemID) {
        this.lineItemID = lineItemID;
        return this;
    }

    @Schema(required=true, description="A unique identifier for an item provided by the client for a direct fulfillment shipment. This is only populated for direct fulfillment multi-piece shipments. It is required if a vendor wants to change the configuration of the packages in which the purchase order is shipped.")
    public String getLineItemID() {
        return this.lineItemID;
    }

    public void setLineItemID(String lineItemID) {
        this.lineItemID = lineItemID;
    }

    public DirectFulfillmentItemIdentifiers pieceNumber(String pieceNumber) {
        this.pieceNumber = pieceNumber;
        return this;
    }

    @Schema(description="A unique identifier for an item provided by the client for a direct fulfillment shipment. This is only populated if a single line item has multiple pieces. Defaults to 1.")
    public String getPieceNumber() {
        return this.pieceNumber;
    }

    public void setPieceNumber(String pieceNumber) {
        this.pieceNumber = pieceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectFulfillmentItemIdentifiers directFulfillmentItemIdentifiers = (DirectFulfillmentItemIdentifiers)o;
        return Objects.equals(this.lineItemID, directFulfillmentItemIdentifiers.lineItemID) && Objects.equals(this.pieceNumber, directFulfillmentItemIdentifiers.pieceNumber);
    }

    public int hashCode() {
        return Objects.hash(this.lineItemID, this.pieceNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectFulfillmentItemIdentifiers {\n");
        sb.append("    lineItemID: ").append(this.toIndentedString(this.lineItemID)).append("\n");
        sb.append("    pieceNumber: ").append(this.toIndentedString(this.pieceNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

