/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="A set of measurements for a three-dimensional object.")
public class Dimensions {
    @SerializedName(value="length")
    private BigDecimal length = null;
    @SerializedName(value="width")
    private BigDecimal width = null;
    @SerializedName(value="height")
    private BigDecimal height = null;
    @SerializedName(value="unit")
    private UnitEnum unit = null;

    public Dimensions length(BigDecimal length) {
        this.length = length;
        return this;
    }

    @Schema(required=true, description="The length of the package.")
    public BigDecimal getLength() {
        return this.length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public Dimensions width(BigDecimal width) {
        this.width = width;
        return this;
    }

    @Schema(required=true, description="The width of the package.")
    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public Dimensions height(BigDecimal height) {
        this.height = height;
        return this;
    }

    @Schema(required=true, description="The height of the package.")
    public BigDecimal getHeight() {
        return this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public Dimensions unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @Schema(required=true, description="The unit of measurement.")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimensions dimensions = (Dimensions)o;
        return Objects.equals(this.length, dimensions.length) && Objects.equals(this.width, dimensions.width) && Objects.equals(this.height, dimensions.height) && Objects.equals((Object)this.unit, (Object)dimensions.unit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.width, this.height, this.unit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dimensions {\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        INCH("INCH"),
        CENTIMETER("CENTIMETER");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String input) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(value);
            }
        }
    }
}

