/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.shipping.v2;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.shipping.v2.ClaimProofURLs;
import software.amazon.spapi.models.shipping.v2.ClaimReason;
import software.amazon.spapi.models.shipping.v2.Currency;
import software.amazon.spapi.models.shipping.v2.SettlementType;

@Schema(description="The request schema for the CreateClaim operation")
public class CreateClaimRequest {
    @SerializedName(value="trackingId")
    private String trackingId = null;
    @SerializedName(value="declaredValue")
    private Currency declaredValue = null;
    @SerializedName(value="claimReason")
    private ClaimReason claimReason = null;
    @SerializedName(value="isReplacementPackageSent")
    private Boolean isReplacementPackageSent = null;
    @SerializedName(value="proofs")
    private ClaimProofURLs proofs = null;
    @SerializedName(value="settlementType")
    private SettlementType settlementType = null;

    public CreateClaimRequest trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    @Schema(required=true, description="")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public CreateClaimRequest declaredValue(Currency declaredValue) {
        this.declaredValue = declaredValue;
        return this;
    }

    @Schema(description="")
    public Currency getDeclaredValue() {
        return this.declaredValue;
    }

    public void setDeclaredValue(Currency declaredValue) {
        this.declaredValue = declaredValue;
    }

    public CreateClaimRequest claimReason(ClaimReason claimReason) {
        this.claimReason = claimReason;
        return this;
    }

    @Schema(required=true, description="")
    public ClaimReason getClaimReason() {
        return this.claimReason;
    }

    public void setClaimReason(ClaimReason claimReason) {
        this.claimReason = claimReason;
    }

    public CreateClaimRequest isReplacementPackageSent(Boolean isReplacementPackageSent) {
        this.isReplacementPackageSent = isReplacementPackageSent;
        return this;
    }

    @Schema(description="Applicable for only On Amazon shipments to identify if replacement was sent")
    public Boolean isIsReplacementPackageSent() {
        return this.isReplacementPackageSent;
    }

    public void setIsReplacementPackageSent(Boolean isReplacementPackageSent) {
        this.isReplacementPackageSent = isReplacementPackageSent;
    }

    public CreateClaimRequest proofs(ClaimProofURLs proofs) {
        this.proofs = proofs;
        return this;
    }

    @Schema(description="")
    public ClaimProofURLs getProofs() {
        return this.proofs;
    }

    public void setProofs(ClaimProofURLs proofs) {
        this.proofs = proofs;
    }

    public CreateClaimRequest settlementType(SettlementType settlementType) {
        this.settlementType = settlementType;
        return this;
    }

    @Schema(required=true, description="")
    public SettlementType getSettlementType() {
        return this.settlementType;
    }

    public void setSettlementType(SettlementType settlementType) {
        this.settlementType = settlementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateClaimRequest createClaimRequest = (CreateClaimRequest)o;
        return Objects.equals(this.trackingId, createClaimRequest.trackingId) && Objects.equals(this.declaredValue, createClaimRequest.declaredValue) && Objects.equals((Object)this.claimReason, (Object)createClaimRequest.claimReason) && Objects.equals(this.isReplacementPackageSent, createClaimRequest.isReplacementPackageSent) && Objects.equals(this.proofs, createClaimRequest.proofs) && Objects.equals((Object)this.settlementType, (Object)createClaimRequest.settlementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.trackingId, this.declaredValue, this.claimReason, this.isReplacementPackageSent, this.proofs, this.settlementType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateClaimRequest {\n");
        sb.append("    trackingId: ").append(this.toIndentedString(this.trackingId)).append("\n");
        sb.append("    declaredValue: ").append(this.toIndentedString(this.declaredValue)).append("\n");
        sb.append("    claimReason: ").append(this.toIndentedString((Object)this.claimReason)).append("\n");
        sb.append("    isReplacementPackageSent: ").append(this.toIndentedString(this.isReplacementPackageSent)).append("\n");
        sb.append("    proofs: ").append(this.toIndentedString(this.proofs)).append("\n");
        sb.append("    settlementType: ").append(this.toIndentedString((Object)this.settlementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

