/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.Appointment;
import software.amazon.spapi.models.services.v1.AppointmentTime;
import software.amazon.spapi.models.services.v1.AssociatedItem;
import software.amazon.spapi.models.services.v1.Buyer;
import software.amazon.spapi.models.services.v1.ScopeOfWork;
import software.amazon.spapi.models.services.v1.Seller;
import software.amazon.spapi.models.services.v1.ServiceJobProvider;
import software.amazon.spapi.models.services.v1.ServiceLocation;

@Schema(description="The job details of a service.")
public class ServiceJob {
    @SerializedName(value="createTime")
    private OffsetDateTime createTime = null;
    @SerializedName(value="serviceJobId")
    private String serviceJobId = null;
    @SerializedName(value="serviceJobStatus")
    private ServiceJobStatusEnum serviceJobStatus = null;
    @SerializedName(value="scopeOfWork")
    private ScopeOfWork scopeOfWork = null;
    @SerializedName(value="seller")
    private Seller seller = null;
    @SerializedName(value="serviceJobProvider")
    private ServiceJobProvider serviceJobProvider = null;
    @SerializedName(value="preferredAppointmentTimes")
    private List<AppointmentTime> preferredAppointmentTimes = null;
    @SerializedName(value="appointments")
    private List<Appointment> appointments = null;
    @SerializedName(value="serviceOrderId")
    private String serviceOrderId = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="storeId")
    private String storeId = null;
    @SerializedName(value="buyer")
    private Buyer buyer = null;
    @SerializedName(value="associatedItems")
    private List<AssociatedItem> associatedItems = null;
    @SerializedName(value="serviceLocation")
    private ServiceLocation serviceLocation = null;

    public ServiceJob createTime(OffsetDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    @Schema(description="The date and time of the creation of the job in ISO 8601 format.")
    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    public ServiceJob serviceJobId(String serviceJobId) {
        this.serviceJobId = serviceJobId;
        return this;
    }

    @Schema(description="")
    public String getServiceJobId() {
        return this.serviceJobId;
    }

    public void setServiceJobId(String serviceJobId) {
        this.serviceJobId = serviceJobId;
    }

    public ServiceJob serviceJobStatus(ServiceJobStatusEnum serviceJobStatus) {
        this.serviceJobStatus = serviceJobStatus;
        return this;
    }

    @Schema(description="The status of the service job.")
    public ServiceJobStatusEnum getServiceJobStatus() {
        return this.serviceJobStatus;
    }

    public void setServiceJobStatus(ServiceJobStatusEnum serviceJobStatus) {
        this.serviceJobStatus = serviceJobStatus;
    }

    public ServiceJob scopeOfWork(ScopeOfWork scopeOfWork) {
        this.scopeOfWork = scopeOfWork;
        return this;
    }

    @Schema(description="")
    public ScopeOfWork getScopeOfWork() {
        return this.scopeOfWork;
    }

    public void setScopeOfWork(ScopeOfWork scopeOfWork) {
        this.scopeOfWork = scopeOfWork;
    }

    public ServiceJob seller(Seller seller) {
        this.seller = seller;
        return this;
    }

    @Schema(description="")
    public Seller getSeller() {
        return this.seller;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public ServiceJob serviceJobProvider(ServiceJobProvider serviceJobProvider) {
        this.serviceJobProvider = serviceJobProvider;
        return this;
    }

    @Schema(description="")
    public ServiceJobProvider getServiceJobProvider() {
        return this.serviceJobProvider;
    }

    public void setServiceJobProvider(ServiceJobProvider serviceJobProvider) {
        this.serviceJobProvider = serviceJobProvider;
    }

    public ServiceJob preferredAppointmentTimes(List<AppointmentTime> preferredAppointmentTimes) {
        this.preferredAppointmentTimes = preferredAppointmentTimes;
        return this;
    }

    public ServiceJob addPreferredAppointmentTimesItem(AppointmentTime preferredAppointmentTimesItem) {
        if (this.preferredAppointmentTimes == null) {
            this.preferredAppointmentTimes = new ArrayList<AppointmentTime>();
        }
        this.preferredAppointmentTimes.add(preferredAppointmentTimesItem);
        return this;
    }

    @Schema(description="A list of appointment windows preferred by the buyer. Included only if the buyer selected appointment windows when creating the order.")
    public List<AppointmentTime> getPreferredAppointmentTimes() {
        return this.preferredAppointmentTimes;
    }

    public void setPreferredAppointmentTimes(List<AppointmentTime> preferredAppointmentTimes) {
        this.preferredAppointmentTimes = preferredAppointmentTimes;
    }

    public ServiceJob appointments(List<Appointment> appointments) {
        this.appointments = appointments;
        return this;
    }

    public ServiceJob addAppointmentsItem(Appointment appointmentsItem) {
        if (this.appointments == null) {
            this.appointments = new ArrayList<Appointment>();
        }
        this.appointments.add(appointmentsItem);
        return this;
    }

    @Schema(description="A list of appointments.")
    public List<Appointment> getAppointments() {
        return this.appointments;
    }

    public void setAppointments(List<Appointment> appointments) {
        this.appointments = appointments;
    }

    public ServiceJob serviceOrderId(String serviceOrderId) {
        this.serviceOrderId = serviceOrderId;
        return this;
    }

    @Schema(description="")
    public String getServiceOrderId() {
        return this.serviceOrderId;
    }

    public void setServiceOrderId(String serviceOrderId) {
        this.serviceOrderId = serviceOrderId;
    }

    public ServiceJob marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="The marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ServiceJob storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Schema(description="The Amazon-defined identifier for the region scope.")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public ServiceJob buyer(Buyer buyer) {
        this.buyer = buyer;
        return this;
    }

    @Schema(description="")
    public Buyer getBuyer() {
        return this.buyer;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public ServiceJob associatedItems(List<AssociatedItem> associatedItems) {
        this.associatedItems = associatedItems;
        return this;
    }

    public ServiceJob addAssociatedItemsItem(AssociatedItem associatedItemsItem) {
        if (this.associatedItems == null) {
            this.associatedItems = new ArrayList<AssociatedItem>();
        }
        this.associatedItems.add(associatedItemsItem);
        return this;
    }

    @Schema(description="A list of items associated with the service job.")
    public List<AssociatedItem> getAssociatedItems() {
        return this.associatedItems;
    }

    public void setAssociatedItems(List<AssociatedItem> associatedItems) {
        this.associatedItems = associatedItems;
    }

    public ServiceJob serviceLocation(ServiceLocation serviceLocation) {
        this.serviceLocation = serviceLocation;
        return this;
    }

    @Schema(description="")
    public ServiceLocation getServiceLocation() {
        return this.serviceLocation;
    }

    public void setServiceLocation(ServiceLocation serviceLocation) {
        this.serviceLocation = serviceLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceJob serviceJob = (ServiceJob)o;
        return Objects.equals(this.createTime, serviceJob.createTime) && Objects.equals(this.serviceJobId, serviceJob.serviceJobId) && Objects.equals((Object)this.serviceJobStatus, (Object)serviceJob.serviceJobStatus) && Objects.equals(this.scopeOfWork, serviceJob.scopeOfWork) && Objects.equals(this.seller, serviceJob.seller) && Objects.equals(this.serviceJobProvider, serviceJob.serviceJobProvider) && Objects.equals(this.preferredAppointmentTimes, serviceJob.preferredAppointmentTimes) && Objects.equals(this.appointments, serviceJob.appointments) && Objects.equals(this.serviceOrderId, serviceJob.serviceOrderId) && Objects.equals(this.marketplaceId, serviceJob.marketplaceId) && Objects.equals(this.storeId, serviceJob.storeId) && Objects.equals(this.buyer, serviceJob.buyer) && Objects.equals(this.associatedItems, serviceJob.associatedItems) && Objects.equals(this.serviceLocation, serviceJob.serviceLocation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createTime, this.serviceJobId, this.serviceJobStatus, this.scopeOfWork, this.seller, this.serviceJobProvider, this.preferredAppointmentTimes, this.appointments, this.serviceOrderId, this.marketplaceId, this.storeId, this.buyer, this.associatedItems, this.serviceLocation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceJob {\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    serviceJobId: ").append(this.toIndentedString(this.serviceJobId)).append("\n");
        sb.append("    serviceJobStatus: ").append(this.toIndentedString((Object)this.serviceJobStatus)).append("\n");
        sb.append("    scopeOfWork: ").append(this.toIndentedString(this.scopeOfWork)).append("\n");
        sb.append("    seller: ").append(this.toIndentedString(this.seller)).append("\n");
        sb.append("    serviceJobProvider: ").append(this.toIndentedString(this.serviceJobProvider)).append("\n");
        sb.append("    preferredAppointmentTimes: ").append(this.toIndentedString(this.preferredAppointmentTimes)).append("\n");
        sb.append("    appointments: ").append(this.toIndentedString(this.appointments)).append("\n");
        sb.append("    serviceOrderId: ").append(this.toIndentedString(this.serviceOrderId)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    buyer: ").append(this.toIndentedString(this.buyer)).append("\n");
        sb.append("    associatedItems: ").append(this.toIndentedString(this.associatedItems)).append("\n");
        sb.append("    serviceLocation: ").append(this.toIndentedString(this.serviceLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ServiceJobStatusEnum {
        NOT_SERVICED("NOT_SERVICED"),
        CANCELLED("CANCELLED"),
        COMPLETED("COMPLETED"),
        PENDING_SCHEDULE("PENDING_SCHEDULE"),
        NOT_FULFILLABLE("NOT_FULFILLABLE"),
        HOLD("HOLD"),
        PAYMENT_DECLINED("PAYMENT_DECLINED");

        private String value;

        private ServiceJobStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ServiceJobStatusEnum fromValue(String input) {
            for (ServiceJobStatusEnum b : ServiceJobStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ServiceJobStatusEnum> {
            public void write(JsonWriter jsonWriter, ServiceJobStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ServiceJobStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ServiceJobStatusEnum.fromValue(value);
            }
        }
    }
}

