/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.EncryptionDetails;

@Schema(description="Information about an upload destination.")
public class ServiceDocumentUploadDestination {
    @SerializedName(value="uploadDestinationId")
    private String uploadDestinationId = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="encryptionDetails")
    private EncryptionDetails encryptionDetails = null;
    @SerializedName(value="headers")
    private Object headers = null;

    public ServiceDocumentUploadDestination uploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
        return this;
    }

    @Schema(required=true, description="The unique identifier to be used by APIs that reference the upload destination.")
    public String getUploadDestinationId() {
        return this.uploadDestinationId;
    }

    public void setUploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
    }

    public ServiceDocumentUploadDestination url(String url) {
        this.url = url;
        return this;
    }

    @Schema(required=true, description="The URL to which to upload the file.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ServiceDocumentUploadDestination encryptionDetails(EncryptionDetails encryptionDetails) {
        this.encryptionDetails = encryptionDetails;
        return this;
    }

    @Schema(required=true, description="")
    public EncryptionDetails getEncryptionDetails() {
        return this.encryptionDetails;
    }

    public void setEncryptionDetails(EncryptionDetails encryptionDetails) {
        this.encryptionDetails = encryptionDetails;
    }

    public ServiceDocumentUploadDestination headers(Object headers) {
        this.headers = headers;
        return this;
    }

    @Schema(description="The headers to include in the upload request.")
    public Object getHeaders() {
        return this.headers;
    }

    public void setHeaders(Object headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDocumentUploadDestination serviceDocumentUploadDestination = (ServiceDocumentUploadDestination)o;
        return Objects.equals(this.uploadDestinationId, serviceDocumentUploadDestination.uploadDestinationId) && Objects.equals(this.url, serviceDocumentUploadDestination.url) && Objects.equals(this.encryptionDetails, serviceDocumentUploadDestination.encryptionDetails) && Objects.equals(this.headers, serviceDocumentUploadDestination.headers);
    }

    public int hashCode() {
        return Objects.hash(this.uploadDestinationId, this.url, this.encryptionDetails, this.headers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceDocumentUploadDestination {\n");
        sb.append("    uploadDestinationId: ").append(this.toIndentedString(this.uploadDestinationId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    encryptionDetails: ").append(this.toIndentedString(this.encryptionDetails)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

