/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.AppointmentTime;
import software.amazon.spapi.models.services.v1.Technician;

@Schema(description="Proof of Appointment (POA) details.")
public class Poa {
    @SerializedName(value="appointmentTime")
    private AppointmentTime appointmentTime = null;
    @SerializedName(value="technicians")
    private List<Technician> technicians = null;
    @SerializedName(value="uploadingTechnician")
    private String uploadingTechnician = null;
    @SerializedName(value="uploadTime")
    private OffsetDateTime uploadTime = null;
    @SerializedName(value="poaType")
    private PoaTypeEnum poaType = null;

    public Poa appointmentTime(AppointmentTime appointmentTime) {
        this.appointmentTime = appointmentTime;
        return this;
    }

    @Schema(description="")
    public AppointmentTime getAppointmentTime() {
        return this.appointmentTime;
    }

    public void setAppointmentTime(AppointmentTime appointmentTime) {
        this.appointmentTime = appointmentTime;
    }

    public Poa technicians(List<Technician> technicians) {
        this.technicians = technicians;
        return this;
    }

    public Poa addTechniciansItem(Technician techniciansItem) {
        if (this.technicians == null) {
            this.technicians = new ArrayList<Technician>();
        }
        this.technicians.add(techniciansItem);
        return this;
    }

    @Schema(description="A list of technicians.")
    public List<Technician> getTechnicians() {
        return this.technicians;
    }

    public void setTechnicians(List<Technician> technicians) {
        this.technicians = technicians;
    }

    public Poa uploadingTechnician(String uploadingTechnician) {
        this.uploadingTechnician = uploadingTechnician;
        return this;
    }

    @Schema(description="The identifier of the technician who uploaded the POA.")
    public String getUploadingTechnician() {
        return this.uploadingTechnician;
    }

    public void setUploadingTechnician(String uploadingTechnician) {
        this.uploadingTechnician = uploadingTechnician;
    }

    public Poa uploadTime(OffsetDateTime uploadTime) {
        this.uploadTime = uploadTime;
        return this;
    }

    @Schema(description="The date and time when the POA was uploaded in ISO 8601 format.")
    public OffsetDateTime getUploadTime() {
        return this.uploadTime;
    }

    public void setUploadTime(OffsetDateTime uploadTime) {
        this.uploadTime = uploadTime;
    }

    public Poa poaType(PoaTypeEnum poaType) {
        this.poaType = poaType;
        return this;
    }

    @Schema(description="The type of POA uploaded.")
    public PoaTypeEnum getPoaType() {
        return this.poaType;
    }

    public void setPoaType(PoaTypeEnum poaType) {
        this.poaType = poaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Poa poa = (Poa)o;
        return Objects.equals(this.appointmentTime, poa.appointmentTime) && Objects.equals(this.technicians, poa.technicians) && Objects.equals(this.uploadingTechnician, poa.uploadingTechnician) && Objects.equals(this.uploadTime, poa.uploadTime) && Objects.equals((Object)this.poaType, (Object)poa.poaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appointmentTime, this.technicians, this.uploadingTechnician, this.uploadTime, this.poaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Poa {\n");
        sb.append("    appointmentTime: ").append(this.toIndentedString(this.appointmentTime)).append("\n");
        sb.append("    technicians: ").append(this.toIndentedString(this.technicians)).append("\n");
        sb.append("    uploadingTechnician: ").append(this.toIndentedString(this.uploadingTechnician)).append("\n");
        sb.append("    uploadTime: ").append(this.toIndentedString(this.uploadTime)).append("\n");
        sb.append("    poaType: ").append(this.toIndentedString((Object)this.poaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PoaTypeEnum {
        NO_SIGNATURE_DUMMY_POS("NO_SIGNATURE_DUMMY_POS"),
        CUSTOMER_SIGNATURE("CUSTOMER_SIGNATURE"),
        DUMMY_RECEIPT("DUMMY_RECEIPT"),
        POA_RECEIPT("POA_RECEIPT");

        private String value;

        private PoaTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PoaTypeEnum fromValue(String input) {
            for (PoaTypeEnum b : PoaTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PoaTypeEnum> {
            public void write(JsonWriter jsonWriter, PoaTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PoaTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PoaTypeEnum.fromValue(value);
            }
        }
    }
}

