/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Document that captured during service appointment fulfillment that portrays proof of completion")
public class FulfillmentDocument {
    @SerializedName(value="uploadDestinationId")
    private String uploadDestinationId = null;
    @SerializedName(value="contentSha256")
    private String contentSha256 = null;

    public FulfillmentDocument uploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
        return this;
    }

    @Schema(description="The identifier of the upload destination. Get this value by calling the `createServiceDocumentUploadDestination` operation of the Services API.")
    public String getUploadDestinationId() {
        return this.uploadDestinationId;
    }

    public void setUploadDestinationId(String uploadDestinationId) {
        this.uploadDestinationId = uploadDestinationId;
    }

    public FulfillmentDocument contentSha256(String contentSha256) {
        this.contentSha256 = contentSha256;
        return this;
    }

    @Schema(description="Sha256 hash of the file content. This value is used to determine if the file has been corrupted or tampered with during transit.")
    public String getContentSha256() {
        return this.contentSha256;
    }

    public void setContentSha256(String contentSha256) {
        this.contentSha256 = contentSha256;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentDocument fulfillmentDocument = (FulfillmentDocument)o;
        return Objects.equals(this.uploadDestinationId, fulfillmentDocument.uploadDestinationId) && Objects.equals(this.contentSha256, fulfillmentDocument.contentSha256);
    }

    public int hashCode() {
        return Objects.hash(this.uploadDestinationId, this.contentSha256);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentDocument {\n");
        sb.append("    uploadDestinationId: ").append(this.toIndentedString(this.uploadDestinationId)).append("\n");
        sb.append("    contentSha256: ").append(this.toIndentedString(this.contentSha256)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

