/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.CapacityType;

@Schema(description="Request schema for the `getFixedSlotCapacity` operation. This schema is used to define the time range, capacity types and slot duration which are being queried.")
public class FixedSlotCapacityQuery {
    @SerializedName(value="capacityTypes")
    private List<CapacityType> capacityTypes = null;
    @SerializedName(value="slotDuration")
    private BigDecimal slotDuration = null;
    @SerializedName(value="startDateTime")
    private OffsetDateTime startDateTime = null;
    @SerializedName(value="endDateTime")
    private OffsetDateTime endDateTime = null;

    public FixedSlotCapacityQuery capacityTypes(List<CapacityType> capacityTypes) {
        this.capacityTypes = capacityTypes;
        return this;
    }

    public FixedSlotCapacityQuery addCapacityTypesItem(CapacityType capacityTypesItem) {
        if (this.capacityTypes == null) {
            this.capacityTypes = new ArrayList<CapacityType>();
        }
        this.capacityTypes.add(capacityTypesItem);
        return this;
    }

    @Schema(description="An array of capacity types which are being requested. Default value is `[SCHEDULED_CAPACITY]`.")
    public List<CapacityType> getCapacityTypes() {
        return this.capacityTypes;
    }

    public void setCapacityTypes(List<CapacityType> capacityTypes) {
        this.capacityTypes = capacityTypes;
    }

    public FixedSlotCapacityQuery slotDuration(BigDecimal slotDuration) {
        this.slotDuration = slotDuration;
        return this;
    }

    @Schema(description="Size in which slots are being requested. This value should be a multiple of 5 and fall in the range: 5 <= `slotDuration` <= 360.")
    public BigDecimal getSlotDuration() {
        return this.slotDuration;
    }

    public void setSlotDuration(BigDecimal slotDuration) {
        this.slotDuration = slotDuration;
    }

    public FixedSlotCapacityQuery startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(required=true, description="Start date time from which the capacity slots are being requested in ISO 8601 format.")
    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public FixedSlotCapacityQuery endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Schema(required=true, description="End date time up to which the capacity slots are being requested in ISO 8601 format.")
    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedSlotCapacityQuery fixedSlotCapacityQuery = (FixedSlotCapacityQuery)o;
        return Objects.equals(this.capacityTypes, fixedSlotCapacityQuery.capacityTypes) && Objects.equals(this.slotDuration, fixedSlotCapacityQuery.slotDuration) && Objects.equals(this.startDateTime, fixedSlotCapacityQuery.startDateTime) && Objects.equals(this.endDateTime, fixedSlotCapacityQuery.endDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.capacityTypes, this.slotDuration, this.startDateTime, this.endDateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FixedSlotCapacityQuery {\n");
        sb.append("    capacityTypes: ").append(this.toIndentedString(this.capacityTypes)).append("\n");
        sb.append("    slotDuration: ").append(this.toIndentedString(this.slotDuration)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

