/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Error response returned when the request is unsuccessful.")
public class Error {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="details")
    private String details = null;
    @SerializedName(value="errorLevel")
    private ErrorLevelEnum errorLevel = null;

    public Error code(String code) {
        this.code = code;
        return this;
    }

    @Schema(required=true, description="An error code that identifies the type of error that occurred.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Schema(required=true, description="A message that describes the error condition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Error details(String details) {
        this.details = details;
        return this;
    }

    @Schema(description="Additional details that can help the caller understand or fix the issue.")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Error errorLevel(ErrorLevelEnum errorLevel) {
        this.errorLevel = errorLevel;
        return this;
    }

    @Schema(description="The type of error.")
    public ErrorLevelEnum getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(ErrorLevelEnum errorLevel) {
        this.errorLevel = errorLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.code, error.code) && Objects.equals(this.message, error.message) && Objects.equals(this.details, error.details) && Objects.equals((Object)this.errorLevel, (Object)error.errorLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message, this.details, this.errorLevel});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    errorLevel: ").append(this.toIndentedString((Object)this.errorLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ErrorLevelEnum {
        ERROR("ERROR"),
        WARNING("WARNING");

        private String value;

        private ErrorLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ErrorLevelEnum fromValue(String input) {
            for (ErrorLevelEnum b : ErrorLevelEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ErrorLevelEnum> {
            public void write(JsonWriter jsonWriter, ErrorLevelEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ErrorLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ErrorLevelEnum.fromValue(value);
            }
        }
    }
}

