/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Encryption details for required client-side encryption and decryption of document contents.")
public class EncryptionDetails {
    @SerializedName(value="standard")
    private StandardEnum standard = null;
    @SerializedName(value="initializationVector")
    private String initializationVector = null;
    @SerializedName(value="key")
    private String key = null;

    public EncryptionDetails standard(StandardEnum standard) {
        this.standard = standard;
        return this;
    }

    @Schema(required=true, description="The encryption standard required to encrypt or decrypt the document contents.")
    public StandardEnum getStandard() {
        return this.standard;
    }

    public void setStandard(StandardEnum standard) {
        this.standard = standard;
    }

    public EncryptionDetails initializationVector(String initializationVector) {
        this.initializationVector = initializationVector;
        return this;
    }

    @Schema(required=true, description="The vector to encrypt or decrypt the document contents using Cipher Block Chaining (CBC).")
    public String getInitializationVector() {
        return this.initializationVector;
    }

    public void setInitializationVector(String initializationVector) {
        this.initializationVector = initializationVector;
    }

    public EncryptionDetails key(String key) {
        this.key = key;
        return this;
    }

    @Schema(required=true, description="The encryption key used to encrypt or decrypt the document contents.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionDetails encryptionDetails = (EncryptionDetails)o;
        return Objects.equals((Object)this.standard, (Object)encryptionDetails.standard) && Objects.equals(this.initializationVector, encryptionDetails.initializationVector) && Objects.equals(this.key, encryptionDetails.key);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.standard, this.initializationVector, this.key});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptionDetails {\n");
        sb.append("    standard: ").append(this.toIndentedString((Object)this.standard)).append("\n");
        sb.append("    initializationVector: ").append(this.toIndentedString(this.initializationVector)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StandardEnum {
        AES("AES");

        private String value;

        private StandardEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StandardEnum fromValue(String input) {
            for (StandardEnum b : StandardEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StandardEnum> {
            public void write(JsonWriter jsonWriter, StandardEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StandardEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StandardEnum.fromValue(value);
            }
        }
    }
}

