/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="A range of time.")
public class DateTimeRange {
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="endTime")
    private OffsetDateTime endTime = null;

    public DateTimeRange startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(required=true, description="The beginning of the time range. Must be in UTC in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) format.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public DateTimeRange endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(required=true, description="The end of the time range. Must be in UTC in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) format.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeRange dateTimeRange = (DateTimeRange)o;
        return Objects.equals(this.startTime, dateTimeRange.startTime) && Objects.equals(this.endTime, dateTimeRange.endTime);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DateTimeRange {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

