/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.services.v1.Recurrence;

@Schema(description="`AvailabilityRecord` to represent the capacity of a resource over a time range.")
public class AvailabilityRecord {
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="endTime")
    private OffsetDateTime endTime = null;
    @SerializedName(value="recurrence")
    private Recurrence recurrence = null;
    @SerializedName(value="capacity")
    private Integer capacity = null;

    public AvailabilityRecord startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(required=true, description="Denotes the time from when the resource is available in a day in ISO-8601 format.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public AvailabilityRecord endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Schema(required=true, description="Denotes the time till when the resource is available in a day in ISO-8601 format.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public AvailabilityRecord recurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    @Schema(description="")
    public Recurrence getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
    }

    public AvailabilityRecord capacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @Schema(description="Signifies the capacity of a resource which is available.")
    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailabilityRecord availabilityRecord = (AvailabilityRecord)o;
        return Objects.equals(this.startTime, availabilityRecord.startTime) && Objects.equals(this.endTime, availabilityRecord.endTime) && Objects.equals(this.recurrence, availabilityRecord.recurrence) && Objects.equals(this.capacity, availabilityRecord.capacity);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.recurrence, this.capacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailabilityRecord {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    recurrence: ").append(this.toIndentedString(this.recurrence)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

