/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.services.v1.ItemDelivery;

@Schema(description="Information about an item associated with the service job.")
public class AssociatedItem {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="orderId")
    private String orderId = null;
    @SerializedName(value="itemStatus")
    private ItemStatusEnum itemStatus = null;
    @SerializedName(value="brandName")
    private String brandName = null;
    @SerializedName(value="itemDelivery")
    private ItemDelivery itemDelivery = null;

    public AssociatedItem asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public AssociatedItem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the item.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AssociatedItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="The total number of items included in the order.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public AssociatedItem orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(description="")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public AssociatedItem itemStatus(ItemStatusEnum itemStatus) {
        this.itemStatus = itemStatus;
        return this;
    }

    @Schema(description="The status of the item.")
    public ItemStatusEnum getItemStatus() {
        return this.itemStatus;
    }

    public void setItemStatus(ItemStatusEnum itemStatus) {
        this.itemStatus = itemStatus;
    }

    public AssociatedItem brandName(String brandName) {
        this.brandName = brandName;
        return this;
    }

    @Schema(description="The brand name of the item.")
    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public AssociatedItem itemDelivery(ItemDelivery itemDelivery) {
        this.itemDelivery = itemDelivery;
        return this;
    }

    @Schema(description="")
    public ItemDelivery getItemDelivery() {
        return this.itemDelivery;
    }

    public void setItemDelivery(ItemDelivery itemDelivery) {
        this.itemDelivery = itemDelivery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociatedItem associatedItem = (AssociatedItem)o;
        return Objects.equals(this.asin, associatedItem.asin) && Objects.equals(this.title, associatedItem.title) && Objects.equals(this.quantity, associatedItem.quantity) && Objects.equals(this.orderId, associatedItem.orderId) && Objects.equals((Object)this.itemStatus, (Object)associatedItem.itemStatus) && Objects.equals(this.brandName, associatedItem.brandName) && Objects.equals(this.itemDelivery, associatedItem.itemDelivery);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asin, this.title, this.quantity, this.orderId, this.itemStatus, this.brandName, this.itemDelivery});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssociatedItem {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    itemStatus: ").append(this.toIndentedString((Object)this.itemStatus)).append("\n");
        sb.append("    brandName: ").append(this.toIndentedString(this.brandName)).append("\n");
        sb.append("    itemDelivery: ").append(this.toIndentedString(this.itemDelivery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ItemStatusEnum {
        ACTIVE("ACTIVE"),
        CANCELLED("CANCELLED"),
        SHIPPED("SHIPPED"),
        DELIVERED("DELIVERED");

        private String value;

        private ItemStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ItemStatusEnum fromValue(String input) {
            for (ItemStatusEnum b : ItemStatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ItemStatusEnum> {
            public void write(JsonWriter jsonWriter, ItemStatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ItemStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ItemStatusEnum.fromValue(value);
            }
        }
    }
}

