/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="The input appointment time details.")
public class AppointmentTimeInput {
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="durationInMinutes")
    private Integer durationInMinutes = null;

    public AppointmentTimeInput startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(required=true, description="The date, time in UTC for the start time of an appointment in ISO 8601 format.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public AppointmentTimeInput durationInMinutes(Integer durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
        return this;
    }

    @Schema(description="The duration of an appointment in minutes.")
    public Integer getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public void setDurationInMinutes(Integer durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppointmentTimeInput appointmentTimeInput = (AppointmentTimeInput)o;
        return Objects.equals(this.startTime, appointmentTimeInput.startTime) && Objects.equals(this.durationInMinutes, appointmentTimeInput.durationInMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.durationInMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppointmentTimeInput {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    durationInMinutes: ").append(this.toIndentedString(this.durationInMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

