/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.services.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="The time of the appointment window.")
public class AppointmentTime {
    @SerializedName(value="startTime")
    private OffsetDateTime startTime = null;
    @SerializedName(value="durationInMinutes")
    private Integer durationInMinutes = null;

    public AppointmentTime startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Schema(required=true, description="The date and time of the start of the appointment window in ISO 8601 format.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public AppointmentTime durationInMinutes(Integer durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
        return this;
    }

    @Schema(required=true, description="The duration of the appointment window, in minutes.")
    public Integer getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public void setDurationInMinutes(Integer durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppointmentTime appointmentTime = (AppointmentTime)o;
        return Objects.equals(this.startTime, appointmentTime.startTime) && Objects.equals(this.durationInMinutes, appointmentTime.durationInMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.durationInMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppointmentTime {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    durationInMinutes: ").append(this.toIndentedString(this.durationInMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

