/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.PaymentPreference;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionInstrumentDetails;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionType;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleInformation;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferScheduleStatus;

@Schema(description="Request body to initiate a scheduled transfer from a SW bank account to another customer defined bank account ")
public class TransferScheduleRequest {
    @SerializedName(value="sourceAccountId")
    private String sourceAccountId = null;
    @SerializedName(value="sourceCurrencyCode")
    private String sourceCurrencyCode = null;
    @SerializedName(value="destinationAccountId")
    private String destinationAccountId = null;
    @SerializedName(value="destinationTransactionInstrument")
    private TransactionInstrumentDetails destinationTransactionInstrument = null;
    @SerializedName(value="transactionType")
    private TransactionType transactionType = null;
    @SerializedName(value="transferScheduleInformation")
    private TransferScheduleInformation transferScheduleInformation = null;
    @SerializedName(value="paymentPreference")
    private PaymentPreference paymentPreference = null;
    @SerializedName(value="transferScheduleStatus")
    private TransferScheduleStatus transferScheduleStatus = null;

    public TransferScheduleRequest sourceAccountId(String sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
        return this;
    }

    @Schema(example="amzn1.account.SMUGN2EN3ZHWSRJKH2KCJPII5JEI", required=true, description="The unique identifier of the source Amazon SW bank account from where the money needs to be debited ")
    public String getSourceAccountId() {
        return this.sourceAccountId;
    }

    public void setSourceAccountId(String sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
    }

    public TransferScheduleRequest sourceCurrencyCode(String sourceCurrencyCode) {
        this.sourceCurrencyCode = sourceCurrencyCode;
        return this;
    }

    @Schema(example="GBP", required=true, description="Represents 3 letter currency code in ISO 4217 standard format of the source payment method country ")
    public String getSourceCurrencyCode() {
        return this.sourceCurrencyCode;
    }

    public void setSourceCurrencyCode(String sourceCurrencyCode) {
        this.sourceCurrencyCode = sourceCurrencyCode;
    }

    public TransferScheduleRequest destinationAccountId(String destinationAccountId) {
        this.destinationAccountId = destinationAccountId;
        return this;
    }

    @Schema(example="amzn1.account.AJKBFWEJFBNH2KCJPII5FBN", required=true, description="Optional field to specify the unique identifier of the destination bank account where the money needs to be deposited ")
    public String getDestinationAccountId() {
        return this.destinationAccountId;
    }

    public void setDestinationAccountId(String destinationAccountId) {
        this.destinationAccountId = destinationAccountId;
    }

    public TransferScheduleRequest destinationTransactionInstrument(TransactionInstrumentDetails destinationTransactionInstrument) {
        this.destinationTransactionInstrument = destinationTransactionInstrument;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionInstrumentDetails getDestinationTransactionInstrument() {
        return this.destinationTransactionInstrument;
    }

    public void setDestinationTransactionInstrument(TransactionInstrumentDetails destinationTransactionInstrument) {
        this.destinationTransactionInstrument = destinationTransactionInstrument;
    }

    public TransferScheduleRequest transactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public TransferScheduleRequest transferScheduleInformation(TransferScheduleInformation transferScheduleInformation) {
        this.transferScheduleInformation = transferScheduleInformation;
        return this;
    }

    @Schema(required=true, description="")
    public TransferScheduleInformation getTransferScheduleInformation() {
        return this.transferScheduleInformation;
    }

    public void setTransferScheduleInformation(TransferScheduleInformation transferScheduleInformation) {
        this.transferScheduleInformation = transferScheduleInformation;
    }

    public TransferScheduleRequest paymentPreference(PaymentPreference paymentPreference) {
        this.paymentPreference = paymentPreference;
        return this;
    }

    @Schema(required=true, description="")
    public PaymentPreference getPaymentPreference() {
        return this.paymentPreference;
    }

    public void setPaymentPreference(PaymentPreference paymentPreference) {
        this.paymentPreference = paymentPreference;
    }

    public TransferScheduleRequest transferScheduleStatus(TransferScheduleStatus transferScheduleStatus) {
        this.transferScheduleStatus = transferScheduleStatus;
        return this;
    }

    @Schema(description="")
    public TransferScheduleStatus getTransferScheduleStatus() {
        return this.transferScheduleStatus;
    }

    public void setTransferScheduleStatus(TransferScheduleStatus transferScheduleStatus) {
        this.transferScheduleStatus = transferScheduleStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferScheduleRequest transferScheduleRequest = (TransferScheduleRequest)o;
        return Objects.equals(this.sourceAccountId, transferScheduleRequest.sourceAccountId) && Objects.equals(this.sourceCurrencyCode, transferScheduleRequest.sourceCurrencyCode) && Objects.equals(this.destinationAccountId, transferScheduleRequest.destinationAccountId) && Objects.equals(this.destinationTransactionInstrument, transferScheduleRequest.destinationTransactionInstrument) && Objects.equals((Object)this.transactionType, (Object)transferScheduleRequest.transactionType) && Objects.equals(this.transferScheduleInformation, transferScheduleRequest.transferScheduleInformation) && Objects.equals(this.paymentPreference, transferScheduleRequest.paymentPreference) && Objects.equals((Object)this.transferScheduleStatus, (Object)transferScheduleRequest.transferScheduleStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceAccountId, this.sourceCurrencyCode, this.destinationAccountId, this.destinationTransactionInstrument, this.transactionType, this.transferScheduleInformation, this.paymentPreference, this.transferScheduleStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferScheduleRequest {\n");
        sb.append("    sourceAccountId: ").append(this.toIndentedString(this.sourceAccountId)).append("\n");
        sb.append("    sourceCurrencyCode: ").append(this.toIndentedString(this.sourceCurrencyCode)).append("\n");
        sb.append("    destinationAccountId: ").append(this.toIndentedString(this.destinationAccountId)).append("\n");
        sb.append("    destinationTransactionInstrument: ").append(this.toIndentedString(this.destinationTransactionInstrument)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    transferScheduleInformation: ").append(this.toIndentedString(this.transferScheduleInformation)).append("\n");
        sb.append("    paymentPreference: ").append(this.toIndentedString(this.paymentPreference)).append("\n");
        sb.append("    transferScheduleStatus: ").append(this.toIndentedString((Object)this.transferScheduleStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

