/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.Currency;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.Fee;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.FxRateDetails;

@Schema(description="The fees and foreign exchange rates that apply to the transaction.  If the fees are in terms of the `baseAmount` (source account) currency, then the effective rate is equal to **1 - (fees * `baseRate` / `baseAmount`)**.  If the fees are in terms of the `transferAmount` (destination account) currency, then the effective rate is equal to **`baseRate` - (fees / `baseAmount`)**.  In the preceding expressions, **fees** is equal to the sum of all `feeAmount.currencyAmount` values in the `fees` array.")
public class TransferRatePreview {
    @SerializedName(value="baseAmount")
    private Currency baseAmount = null;
    @SerializedName(value="fxRateDetails")
    private FxRateDetails fxRateDetails = null;
    @SerializedName(value="transferAmount")
    private Currency transferAmount = null;
    @SerializedName(value="fees")
    private List<Fee> fees = new ArrayList<Fee>();

    public TransferRatePreview baseAmount(Currency baseAmount) {
        this.baseAmount = baseAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(Currency baseAmount) {
        this.baseAmount = baseAmount;
    }

    public TransferRatePreview fxRateDetails(FxRateDetails fxRateDetails) {
        this.fxRateDetails = fxRateDetails;
        return this;
    }

    @Schema(required=true, description="")
    public FxRateDetails getFxRateDetails() {
        return this.fxRateDetails;
    }

    public void setFxRateDetails(FxRateDetails fxRateDetails) {
        this.fxRateDetails = fxRateDetails;
    }

    public TransferRatePreview transferAmount(Currency transferAmount) {
        this.transferAmount = transferAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getTransferAmount() {
        return this.transferAmount;
    }

    public void setTransferAmount(Currency transferAmount) {
        this.transferAmount = transferAmount;
    }

    public TransferRatePreview fees(List<Fee> fees) {
        this.fees = fees;
        return this;
    }

    public TransferRatePreview addFeesItem(Fee feesItem) {
        this.fees.add(feesItem);
        return this;
    }

    @Schema(required=true, description="List of fees ")
    public List<Fee> getFees() {
        return this.fees;
    }

    public void setFees(List<Fee> fees) {
        this.fees = fees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRatePreview transferRatePreview = (TransferRatePreview)o;
        return Objects.equals(this.baseAmount, transferRatePreview.baseAmount) && Objects.equals(this.fxRateDetails, transferRatePreview.fxRateDetails) && Objects.equals(this.transferAmount, transferRatePreview.transferAmount) && Objects.equals(this.fees, transferRatePreview.fees);
    }

    public int hashCode() {
        return Objects.hash(this.baseAmount, this.fxRateDetails, this.transferAmount, this.fees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRatePreview {\n");
        sb.append("    baseAmount: ").append(this.toIndentedString(this.baseAmount)).append("\n");
        sb.append("    fxRateDetails: ").append(this.toIndentedString(this.fxRateDetails)).append("\n");
        sb.append("    transferAmount: ").append(this.toIndentedString(this.transferAmount)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

