/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccount;

@Schema(description="Request body to create transaction instrument, Amazon performs validation and screening (anti-money laundering measuers) on all the transaction instruments before executing a transaction thus it requires transaction instrument holder's contact details as well ")
public class TransactionInstrumentDetails {
    @SerializedName(value="bankAccount")
    private BankAccount bankAccount = null;
    @SerializedName(value="bankAccountNumber")
    private String bankAccountNumber = null;
    @SerializedName(value="accountHolderName")
    private String accountHolderName = null;

    public TransactionInstrumentDetails bankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @Schema(required=true, description="")
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public TransactionInstrumentDetails bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @Schema(example="GB29RBOS60161331926819", required=true, description="This field would be used to populate the bank account number of the destination payment method. The field is intentionally not included in any other Schemas since Amazon internal systems will never receive it in unencrypted format, so field won't be part of the request signature ")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public TransactionInstrumentDetails accountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
        return this;
    }

    @Schema(example="John Doe", required=true, description="The bank account holder's name (expected to be an Amazon customer).  **Note:** This field is encrypted before Amazon receives it, so should not be used to generate `destAccountDigitalSignature`, and should not be included in the request signature.")
    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInstrumentDetails transactionInstrumentDetails = (TransactionInstrumentDetails)o;
        return Objects.equals(this.bankAccount, transactionInstrumentDetails.bankAccount) && Objects.equals(this.bankAccountNumber, transactionInstrumentDetails.bankAccountNumber) && Objects.equals(this.accountHolderName, transactionInstrumentDetails.accountHolderName);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccount, this.bankAccountNumber, this.accountHolderName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionInstrumentDetails {\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    accountHolderName: ").append(this.toIndentedString(this.accountHolderName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

