/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.AccountHolderAddress;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.Currency;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionInstrumentDetails;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferRatePreview;

@Schema(description="Request body to initiate a transaction from a SW bank account to another customer defined bank account ")
public class TransactionInitiationRequest {
    @SerializedName(value="sourceAccountId")
    private String sourceAccountId = null;
    @SerializedName(value="destinationAccountId")
    private String destinationAccountId = null;
    @SerializedName(value="destinationTransactionInstrument")
    private TransactionInstrumentDetails destinationTransactionInstrument = null;
    @SerializedName(value="transactionDescription")
    private String transactionDescription = null;
    @SerializedName(value="customerPaymentReference")
    private String customerPaymentReference = null;
    @SerializedName(value="destinationAccountHolderAddress")
    private AccountHolderAddress destinationAccountHolderAddress = null;
    @SerializedName(value="sourceAmount")
    private Currency sourceAmount = null;
    @SerializedName(value="transferRateDetails")
    private TransferRatePreview transferRateDetails = null;
    @SerializedName(value="requestTime")
    private OffsetDateTime requestTime = null;

    public TransactionInitiationRequest sourceAccountId(String sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
        return this;
    }

    @Schema(example="amzn1.account.SMUGN2EN3ZHWSRJKH2KCJPII5JEI", required=true, description="The unique identifier of the source Amazon SW bank account from where the money needs to be debited ")
    public String getSourceAccountId() {
        return this.sourceAccountId;
    }

    public void setSourceAccountId(String sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
    }

    public TransactionInitiationRequest destinationAccountId(String destinationAccountId) {
        this.destinationAccountId = destinationAccountId;
        return this;
    }

    @Schema(example="amzn1.account.AJKBFWEJFBNH2KCJPII5FBN", description="Optional field to specify the unique identifier of the destination bank account where the money needs to be deposited ")
    public String getDestinationAccountId() {
        return this.destinationAccountId;
    }

    public void setDestinationAccountId(String destinationAccountId) {
        this.destinationAccountId = destinationAccountId;
    }

    public TransactionInitiationRequest destinationTransactionInstrument(TransactionInstrumentDetails destinationTransactionInstrument) {
        this.destinationTransactionInstrument = destinationTransactionInstrument;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionInstrumentDetails getDestinationTransactionInstrument() {
        return this.destinationTransactionInstrument;
    }

    public void setDestinationTransactionInstrument(TransactionInstrumentDetails destinationTransactionInstrument) {
        this.destinationTransactionInstrument = destinationTransactionInstrument;
    }

    public TransactionInitiationRequest transactionDescription(String transactionDescription) {
        this.transactionDescription = transactionDescription;
        return this;
    }

    @Schema(description="A description of the transaction.")
    public String getTransactionDescription() {
        return this.transactionDescription;
    }

    public void setTransactionDescription(String transactionDescription) {
        this.transactionDescription = transactionDescription;
    }

    public TransactionInitiationRequest customerPaymentReference(String customerPaymentReference) {
        this.customerPaymentReference = customerPaymentReference;
        return this;
    }

    @Schema(example="BG999999999", description="If the payment is for VAT (Value-Added-Tax) then enter VAT identification number in this field which will be mandatory. The length constraint is 140 characters and do not allow user to enter any sensitive information other than VAT-ID.")
    public String getCustomerPaymentReference() {
        return this.customerPaymentReference;
    }

    public void setCustomerPaymentReference(String customerPaymentReference) {
        this.customerPaymentReference = customerPaymentReference;
    }

    public TransactionInitiationRequest destinationAccountHolderAddress(AccountHolderAddress destinationAccountHolderAddress) {
        this.destinationAccountHolderAddress = destinationAccountHolderAddress;
        return this;
    }

    @Schema(description="")
    public AccountHolderAddress getDestinationAccountHolderAddress() {
        return this.destinationAccountHolderAddress;
    }

    public void setDestinationAccountHolderAddress(AccountHolderAddress destinationAccountHolderAddress) {
        this.destinationAccountHolderAddress = destinationAccountHolderAddress;
    }

    public TransactionInitiationRequest sourceAmount(Currency sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getSourceAmount() {
        return this.sourceAmount;
    }

    public void setSourceAmount(Currency sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public TransactionInitiationRequest transferRateDetails(TransferRatePreview transferRateDetails) {
        this.transferRateDetails = transferRateDetails;
        return this;
    }

    @Schema(description="")
    public TransferRatePreview getTransferRateDetails() {
        return this.transferRateDetails;
    }

    public void setTransferRateDetails(TransferRatePreview transferRateDetails) {
        this.transferRateDetails = transferRateDetails;
    }

    public TransactionInitiationRequest requestTime(OffsetDateTime requestTime) {
        this.requestTime = requestTime;
        return this;
    }

    @Schema(example="2024-03-26T02:32:59.787Z", required=true, description="The transaction initiation request time in date-time format ")
    public OffsetDateTime getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(OffsetDateTime requestTime) {
        this.requestTime = requestTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInitiationRequest transactionInitiationRequest = (TransactionInitiationRequest)o;
        return Objects.equals(this.sourceAccountId, transactionInitiationRequest.sourceAccountId) && Objects.equals(this.destinationAccountId, transactionInitiationRequest.destinationAccountId) && Objects.equals(this.destinationTransactionInstrument, transactionInitiationRequest.destinationTransactionInstrument) && Objects.equals(this.transactionDescription, transactionInitiationRequest.transactionDescription) && Objects.equals(this.customerPaymentReference, transactionInitiationRequest.customerPaymentReference) && Objects.equals(this.destinationAccountHolderAddress, transactionInitiationRequest.destinationAccountHolderAddress) && Objects.equals(this.sourceAmount, transactionInitiationRequest.sourceAmount) && Objects.equals(this.transferRateDetails, transactionInitiationRequest.transferRateDetails) && Objects.equals(this.requestTime, transactionInitiationRequest.requestTime);
    }

    public int hashCode() {
        return Objects.hash(this.sourceAccountId, this.destinationAccountId, this.destinationTransactionInstrument, this.transactionDescription, this.customerPaymentReference, this.destinationAccountHolderAddress, this.sourceAmount, this.transferRateDetails, this.requestTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionInitiationRequest {\n");
        sb.append("    sourceAccountId: ").append(this.toIndentedString(this.sourceAccountId)).append("\n");
        sb.append("    destinationAccountId: ").append(this.toIndentedString(this.destinationAccountId)).append("\n");
        sb.append("    destinationTransactionInstrument: ").append(this.toIndentedString(this.destinationTransactionInstrument)).append("\n");
        sb.append("    transactionDescription: ").append(this.toIndentedString(this.transactionDescription)).append("\n");
        sb.append("    customerPaymentReference: ").append(this.toIndentedString(this.customerPaymentReference)).append("\n");
        sb.append("    destinationAccountHolderAddress: ").append(this.toIndentedString(this.destinationAccountHolderAddress)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    transferRateDetails: ").append(this.toIndentedString(this.transferRateDetails)).append("\n");
        sb.append("    requestTime: ").append(this.toIndentedString(this.requestTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

