/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccountNumberFormat;

@Schema(description="Details of the bank account involved in the transaction.")
public class TransactionAccount {
    @SerializedName(value="accountId")
    private String accountId = null;
    @SerializedName(value="bankAccountHolderName")
    private String bankAccountHolderName = null;
    @SerializedName(value="bankName")
    private String bankName = null;
    @SerializedName(value="bankAccountNumberFormat")
    private BankAccountNumberFormat bankAccountNumberFormat = null;
    @SerializedName(value="bankAccountNumberTail")
    private String bankAccountNumberTail = null;
    @SerializedName(value="bankAccountCountryCode")
    private String bankAccountCountryCode = null;
    @SerializedName(value="bankAccountCurrency")
    private String bankAccountCurrency = null;

    public TransactionAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="The unique identifier provided by Amazon to identify the account ")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransactionAccount bankAccountHolderName(String bankAccountHolderName) {
        this.bankAccountHolderName = bankAccountHolderName;
        return this;
    }

    @Schema(description="BankAccount holder's name ")
    public String getBankAccountHolderName() {
        return this.bankAccountHolderName;
    }

    public void setBankAccountHolderName(String bankAccountHolderName) {
        this.bankAccountHolderName = bankAccountHolderName;
    }

    public TransactionAccount bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Schema(required=true, description="The name of the bank ")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public TransactionAccount bankAccountNumberFormat(BankAccountNumberFormat bankAccountNumberFormat) {
        this.bankAccountNumberFormat = bankAccountNumberFormat;
        return this;
    }

    @Schema(required=true, description="")
    public BankAccountNumberFormat getBankAccountNumberFormat() {
        return this.bankAccountNumberFormat;
    }

    public void setBankAccountNumberFormat(BankAccountNumberFormat bankAccountNumberFormat) {
        this.bankAccountNumberFormat = bankAccountNumberFormat;
    }

    public TransactionAccount bankAccountNumberTail(String bankAccountNumberTail) {
        this.bankAccountNumberTail = bankAccountNumberTail;
        return this;
    }

    @Schema(description="Last 3 digit of the bank account number ")
    public String getBankAccountNumberTail() {
        return this.bankAccountNumberTail;
    }

    public void setBankAccountNumberTail(String bankAccountNumberTail) {
        this.bankAccountNumberTail = bankAccountNumberTail;
    }

    public TransactionAccount bankAccountCountryCode(String bankAccountCountryCode) {
        this.bankAccountCountryCode = bankAccountCountryCode;
        return this;
    }

    @Schema(description="The two digit country code, in ISO 3166 format. This field is OPTIONAL for transactionSourceAccount object but is MANDATORY field for transactionDestinationAccount ")
    public String getBankAccountCountryCode() {
        return this.bankAccountCountryCode;
    }

    public void setBankAccountCountryCode(String bankAccountCountryCode) {
        this.bankAccountCountryCode = bankAccountCountryCode;
    }

    public TransactionAccount bankAccountCurrency(String bankAccountCurrency) {
        this.bankAccountCurrency = bankAccountCurrency;
        return this;
    }

    @Schema(required=true, description="The currency code in ISO 4217 format ")
    public String getBankAccountCurrency() {
        return this.bankAccountCurrency;
    }

    public void setBankAccountCurrency(String bankAccountCurrency) {
        this.bankAccountCurrency = bankAccountCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionAccount transactionAccount = (TransactionAccount)o;
        return Objects.equals(this.accountId, transactionAccount.accountId) && Objects.equals(this.bankAccountHolderName, transactionAccount.bankAccountHolderName) && Objects.equals(this.bankName, transactionAccount.bankName) && Objects.equals((Object)this.bankAccountNumberFormat, (Object)transactionAccount.bankAccountNumberFormat) && Objects.equals(this.bankAccountNumberTail, transactionAccount.bankAccountNumberTail) && Objects.equals(this.bankAccountCountryCode, transactionAccount.bankAccountCountryCode) && Objects.equals(this.bankAccountCurrency, transactionAccount.bankAccountCurrency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.bankAccountHolderName, this.bankName, this.bankAccountNumberFormat, this.bankAccountNumberTail, this.bankAccountCountryCode, this.bankAccountCurrency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    bankAccountHolderName: ").append(this.toIndentedString(this.bankAccountHolderName)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    bankAccountNumberFormat: ").append(this.toIndentedString((Object)this.bankAccountNumberFormat)).append("\n");
        sb.append("    bankAccountNumberTail: ").append(this.toIndentedString(this.bankAccountNumberTail)).append("\n");
        sb.append("    bankAccountCountryCode: ").append(this.toIndentedString(this.bankAccountCountryCode)).append("\n");
        sb.append("    bankAccountCurrency: ").append(this.toIndentedString(this.bankAccountCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

