/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.Currency;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionAccount;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionStatus;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransactionType;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.TransferRatePreview;

@Schema(description="The current transaction status and related historical details.")
public class Transaction {
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="transactionType")
    private TransactionType transactionType = null;
    @SerializedName(value="transactionStatus")
    private TransactionStatus transactionStatus = null;
    @SerializedName(value="transactionRequestDate")
    private OffsetDateTime transactionRequestDate = null;
    @SerializedName(value="expectedCompletionDate")
    private OffsetDateTime expectedCompletionDate = null;
    @SerializedName(value="transactionActualCompletionDate")
    private OffsetDateTime transactionActualCompletionDate = null;
    @SerializedName(value="lastUpdateDate")
    private OffsetDateTime lastUpdateDate = null;
    @SerializedName(value="requesterName")
    private String requesterName = null;
    @SerializedName(value="transactionRequesterSource")
    private String transactionRequesterSource = null;
    @SerializedName(value="transactionDescription")
    private String transactionDescription = null;
    @SerializedName(value="transactionSourceAccount")
    private TransactionAccount transactionSourceAccount = null;
    @SerializedName(value="transactionDestinationAccount")
    private TransactionAccount transactionDestinationAccount = null;
    @SerializedName(value="transactionRequestAmount")
    private Currency transactionRequestAmount = null;
    @SerializedName(value="transferRateDetails")
    private TransferRatePreview transferRateDetails = null;
    @SerializedName(value="transactionFinalAmount")
    private Currency transactionFinalAmount = null;
    @SerializedName(value="transactionFailureReason")
    private String transactionFailureReason = null;

    public Transaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(required=true, description="The unique identifier provided by Amazon to the transaction ")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Transaction transactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public Transaction transactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Transaction transactionRequestDate(OffsetDateTime transactionRequestDate) {
        this.transactionRequestDate = transactionRequestDate;
        return this;
    }

    @Schema(required=true, description="The date when the transaction was initiated.")
    public OffsetDateTime getTransactionRequestDate() {
        return this.transactionRequestDate;
    }

    public void setTransactionRequestDate(OffsetDateTime transactionRequestDate) {
        this.transactionRequestDate = transactionRequestDate;
    }

    public Transaction expectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
        return this;
    }

    @Schema(example="2023-09-26T02:32:59.787Z", description="Expected completion date of a transaction, for existing active Payees (Trusted Beneficiaries) it will be 24 hours but for new destination bank accounts the value could go up to 5 days ")
    public OffsetDateTime getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public void setExpectedCompletionDate(OffsetDateTime expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public Transaction transactionActualCompletionDate(OffsetDateTime transactionActualCompletionDate) {
        this.transactionActualCompletionDate = transactionActualCompletionDate;
        return this;
    }

    @Schema(description="Transaction completion date ")
    public OffsetDateTime getTransactionActualCompletionDate() {
        return this.transactionActualCompletionDate;
    }

    public void setTransactionActualCompletionDate(OffsetDateTime transactionActualCompletionDate) {
        this.transactionActualCompletionDate = transactionActualCompletionDate;
    }

    public Transaction lastUpdateDate(OffsetDateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Schema(required=true, description="The last update date on the transaction ")
    public OffsetDateTime getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(OffsetDateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public Transaction requesterName(String requesterName) {
        this.requesterName = requesterName;
        return this;
    }

    @Schema(example="TPPOrgId", description="Amazon SW customer who requested the transaction ")
    public String getRequesterName() {
        return this.requesterName;
    }

    public void setRequesterName(String requesterName) {
        this.requesterName = requesterName;
    }

    public Transaction transactionRequesterSource(String transactionRequesterSource) {
        this.transactionRequesterSource = transactionRequesterSource;
        return this;
    }

    @Schema(required=true, description="The transaction initiation source. This value is either the Amazon portal or PISP name that the customer used to start the transaction.")
    public String getTransactionRequesterSource() {
        return this.transactionRequesterSource;
    }

    public void setTransactionRequesterSource(String transactionRequesterSource) {
        this.transactionRequesterSource = transactionRequesterSource;
    }

    public Transaction transactionDescription(String transactionDescription) {
        this.transactionDescription = transactionDescription;
        return this;
    }

    @Schema(required=true, description="A description of the transaction that the requester provides when they initiate the transaction.")
    public String getTransactionDescription() {
        return this.transactionDescription;
    }

    public void setTransactionDescription(String transactionDescription) {
        this.transactionDescription = transactionDescription;
    }

    public Transaction transactionSourceAccount(TransactionAccount transactionSourceAccount) {
        this.transactionSourceAccount = transactionSourceAccount;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionAccount getTransactionSourceAccount() {
        return this.transactionSourceAccount;
    }

    public void setTransactionSourceAccount(TransactionAccount transactionSourceAccount) {
        this.transactionSourceAccount = transactionSourceAccount;
    }

    public Transaction transactionDestinationAccount(TransactionAccount transactionDestinationAccount) {
        this.transactionDestinationAccount = transactionDestinationAccount;
        return this;
    }

    @Schema(required=true, description="")
    public TransactionAccount getTransactionDestinationAccount() {
        return this.transactionDestinationAccount;
    }

    public void setTransactionDestinationAccount(TransactionAccount transactionDestinationAccount) {
        this.transactionDestinationAccount = transactionDestinationAccount;
    }

    public Transaction transactionRequestAmount(Currency transactionRequestAmount) {
        this.transactionRequestAmount = transactionRequestAmount;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getTransactionRequestAmount() {
        return this.transactionRequestAmount;
    }

    public void setTransactionRequestAmount(Currency transactionRequestAmount) {
        this.transactionRequestAmount = transactionRequestAmount;
    }

    public Transaction transferRateDetails(TransferRatePreview transferRateDetails) {
        this.transferRateDetails = transferRateDetails;
        return this;
    }

    @Schema(required=true, description="")
    public TransferRatePreview getTransferRateDetails() {
        return this.transferRateDetails;
    }

    public void setTransferRateDetails(TransferRatePreview transferRateDetails) {
        this.transferRateDetails = transferRateDetails;
    }

    public Transaction transactionFinalAmount(Currency transactionFinalAmount) {
        this.transactionFinalAmount = transactionFinalAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTransactionFinalAmount() {
        return this.transactionFinalAmount;
    }

    public void setTransactionFinalAmount(Currency transactionFinalAmount) {
        this.transactionFinalAmount = transactionFinalAmount;
    }

    public Transaction transactionFailureReason(String transactionFailureReason) {
        this.transactionFailureReason = transactionFailureReason;
        return this;
    }

    @Schema(example="Insufficient Balance", description="Description in case the transaction fails before completion ")
    public String getTransactionFailureReason() {
        return this.transactionFailureReason;
    }

    public void setTransactionFailureReason(String transactionFailureReason) {
        this.transactionFailureReason = transactionFailureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.transactionId, transaction.transactionId) && Objects.equals((Object)this.transactionType, (Object)transaction.transactionType) && Objects.equals((Object)this.transactionStatus, (Object)transaction.transactionStatus) && Objects.equals(this.transactionRequestDate, transaction.transactionRequestDate) && Objects.equals(this.expectedCompletionDate, transaction.expectedCompletionDate) && Objects.equals(this.transactionActualCompletionDate, transaction.transactionActualCompletionDate) && Objects.equals(this.lastUpdateDate, transaction.lastUpdateDate) && Objects.equals(this.requesterName, transaction.requesterName) && Objects.equals(this.transactionRequesterSource, transaction.transactionRequesterSource) && Objects.equals(this.transactionDescription, transaction.transactionDescription) && Objects.equals(this.transactionSourceAccount, transaction.transactionSourceAccount) && Objects.equals(this.transactionDestinationAccount, transaction.transactionDestinationAccount) && Objects.equals(this.transactionRequestAmount, transaction.transactionRequestAmount) && Objects.equals(this.transferRateDetails, transaction.transferRateDetails) && Objects.equals(this.transactionFinalAmount, transaction.transactionFinalAmount) && Objects.equals(this.transactionFailureReason, transaction.transactionFailureReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.transactionType, this.transactionStatus, this.transactionRequestDate, this.expectedCompletionDate, this.transactionActualCompletionDate, this.lastUpdateDate, this.requesterName, this.transactionRequesterSource, this.transactionDescription, this.transactionSourceAccount, this.transactionDestinationAccount, this.transactionRequestAmount, this.transferRateDetails, this.transactionFinalAmount, this.transactionFailureReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("    transactionRequestDate: ").append(this.toIndentedString(this.transactionRequestDate)).append("\n");
        sb.append("    expectedCompletionDate: ").append(this.toIndentedString(this.expectedCompletionDate)).append("\n");
        sb.append("    transactionActualCompletionDate: ").append(this.toIndentedString(this.transactionActualCompletionDate)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("    requesterName: ").append(this.toIndentedString(this.requesterName)).append("\n");
        sb.append("    transactionRequesterSource: ").append(this.toIndentedString(this.transactionRequesterSource)).append("\n");
        sb.append("    transactionDescription: ").append(this.toIndentedString(this.transactionDescription)).append("\n");
        sb.append("    transactionSourceAccount: ").append(this.toIndentedString(this.transactionSourceAccount)).append("\n");
        sb.append("    transactionDestinationAccount: ").append(this.toIndentedString(this.transactionDestinationAccount)).append("\n");
        sb.append("    transactionRequestAmount: ").append(this.toIndentedString(this.transactionRequestAmount)).append("\n");
        sb.append("    transferRateDetails: ").append(this.toIndentedString(this.transferRateDetails)).append("\n");
        sb.append("    transactionFinalAmount: ").append(this.toIndentedString(this.transactionFinalAmount)).append("\n");
        sb.append("    transactionFailureReason: ").append(this.toIndentedString(this.transactionFailureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

