/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccountHolderStatus;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccountNumberFormat;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankAccountOwnershipType;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BankNumberFormat;

@Schema(description="Details of an Amazon SW bank account, used to hold money earned by a SW customer by selling items. NOTE: Not including account_links, short cut links to the account balance and transactions -> since not mandatory ")
public class BankAccount {
    @SerializedName(value="accountId")
    private String accountId = null;
    @SerializedName(value="accountHolderName")
    private String accountHolderName = null;
    @SerializedName(value="bankAccountNumberFormat")
    private BankAccountNumberFormat bankAccountNumberFormat = null;
    @SerializedName(value="bankName")
    private String bankName = null;
    @SerializedName(value="bankAccountOwnershipType")
    private BankAccountOwnershipType bankAccountOwnershipType = null;
    @SerializedName(value="routingNumber")
    private String routingNumber = null;
    @SerializedName(value="bankNumberFormat")
    private BankNumberFormat bankNumberFormat = null;
    @SerializedName(value="accountCountryCode")
    private String accountCountryCode = null;
    @SerializedName(value="accountCurrency")
    private String accountCurrency = null;
    @SerializedName(value="bankAccountNumberTail")
    private String bankAccountNumberTail = null;
    @SerializedName(value="bankAccountHolderStatus")
    private BankAccountHolderStatus bankAccountHolderStatus = null;

    public BankAccount accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(example="amzn1.account.AGUGL2EM3ZHYSRJWH2UCRPIM5JFQ", description="The unique identifier provided by Amazon to identify the account ")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankAccount accountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
        return this;
    }

    @Schema(example="John Doe", description="BankAccount holder's name (expected to be Amazon customer) ")
    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    public BankAccount bankAccountNumberFormat(BankAccountNumberFormat bankAccountNumberFormat) {
        this.bankAccountNumberFormat = bankAccountNumberFormat;
        return this;
    }

    @Schema(required=true, description="")
    public BankAccountNumberFormat getBankAccountNumberFormat() {
        return this.bankAccountNumberFormat;
    }

    public void setBankAccountNumberFormat(BankAccountNumberFormat bankAccountNumberFormat) {
        this.bankAccountNumberFormat = bankAccountNumberFormat;
    }

    public BankAccount bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Schema(example="Bank Of America", description="The name of the bank, for all Amazon Seller Wallet account the value will be Amazon Seller Wallet ")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BankAccount bankAccountOwnershipType(BankAccountOwnershipType bankAccountOwnershipType) {
        this.bankAccountOwnershipType = bankAccountOwnershipType;
        return this;
    }

    @Schema(required=true, description="")
    public BankAccountOwnershipType getBankAccountOwnershipType() {
        return this.bankAccountOwnershipType;
    }

    public void setBankAccountOwnershipType(BankAccountOwnershipType bankAccountOwnershipType) {
        this.bankAccountOwnershipType = bankAccountOwnershipType;
    }

    public BankAccount routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Schema(example="026009593", required=true, description="Routing number for automated clearing house transfers, for all Amazon Seller Wallet account the value will be denoted by nine cosecutive 0's,  ")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public BankAccount bankNumberFormat(BankNumberFormat bankNumberFormat) {
        this.bankNumberFormat = bankNumberFormat;
        return this;
    }

    @Schema(required=true, description="")
    public BankNumberFormat getBankNumberFormat() {
        return this.bankNumberFormat;
    }

    public void setBankNumberFormat(BankNumberFormat bankNumberFormat) {
        this.bankNumberFormat = bankNumberFormat;
    }

    public BankAccount accountCountryCode(String accountCountryCode) {
        this.accountCountryCode = accountCountryCode;
        return this;
    }

    @Schema(example="US", required=true, description="The two digit country code, in ISO 3166 format. ")
    public String getAccountCountryCode() {
        return this.accountCountryCode;
    }

    public void setAccountCountryCode(String accountCountryCode) {
        this.accountCountryCode = accountCountryCode;
    }

    public BankAccount accountCurrency(String accountCurrency) {
        this.accountCurrency = accountCurrency;
        return this;
    }

    @Schema(example="USD", required=true, description="BankAccount currency code in ISO 4217 format ")
    public String getAccountCurrency() {
        return this.accountCurrency;
    }

    public void setAccountCurrency(String accountCurrency) {
        this.accountCurrency = accountCurrency;
    }

    public BankAccount bankAccountNumberTail(String bankAccountNumberTail) {
        this.bankAccountNumberTail = bankAccountNumberTail;
        return this;
    }

    @Schema(example="666", required=true, description="Last 3 digit of the bank account number, for all Amazon Seller Wallet account the value will be three consecutive 0's ")
    public String getBankAccountNumberTail() {
        return this.bankAccountNumberTail;
    }

    public void setBankAccountNumberTail(String bankAccountNumberTail) {
        this.bankAccountNumberTail = bankAccountNumberTail;
    }

    public BankAccount bankAccountHolderStatus(BankAccountHolderStatus bankAccountHolderStatus) {
        this.bankAccountHolderStatus = bankAccountHolderStatus;
        return this;
    }

    @Schema(description="")
    public BankAccountHolderStatus getBankAccountHolderStatus() {
        return this.bankAccountHolderStatus;
    }

    public void setBankAccountHolderStatus(BankAccountHolderStatus bankAccountHolderStatus) {
        this.bankAccountHolderStatus = bankAccountHolderStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)o;
        return Objects.equals(this.accountId, bankAccount.accountId) && Objects.equals(this.accountHolderName, bankAccount.accountHolderName) && Objects.equals((Object)this.bankAccountNumberFormat, (Object)bankAccount.bankAccountNumberFormat) && Objects.equals(this.bankName, bankAccount.bankName) && Objects.equals((Object)this.bankAccountOwnershipType, (Object)bankAccount.bankAccountOwnershipType) && Objects.equals(this.routingNumber, bankAccount.routingNumber) && Objects.equals((Object)this.bankNumberFormat, (Object)bankAccount.bankNumberFormat) && Objects.equals(this.accountCountryCode, bankAccount.accountCountryCode) && Objects.equals(this.accountCurrency, bankAccount.accountCurrency) && Objects.equals(this.bankAccountNumberTail, bankAccount.bankAccountNumberTail) && Objects.equals((Object)this.bankAccountHolderStatus, (Object)bankAccount.bankAccountHolderStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.accountHolderName, this.bankAccountNumberFormat, this.bankName, this.bankAccountOwnershipType, this.routingNumber, this.bankNumberFormat, this.accountCountryCode, this.accountCurrency, this.bankAccountNumberTail, this.bankAccountHolderStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountHolderName: ").append(this.toIndentedString(this.accountHolderName)).append("\n");
        sb.append("    bankAccountNumberFormat: ").append(this.toIndentedString((Object)this.bankAccountNumberFormat)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    bankAccountOwnershipType: ").append(this.toIndentedString((Object)this.bankAccountOwnershipType)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    bankNumberFormat: ").append(this.toIndentedString((Object)this.bankNumberFormat)).append("\n");
        sb.append("    accountCountryCode: ").append(this.toIndentedString(this.accountCountryCode)).append("\n");
        sb.append("    accountCurrency: ").append(this.toIndentedString(this.accountCurrency)).append("\n");
        sb.append("    bankAccountNumberTail: ").append(this.toIndentedString(this.bankAccountNumberTail)).append("\n");
        sb.append("    bankAccountHolderStatus: ").append(this.toIndentedString((Object)this.bankAccountHolderStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

