/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellerwallet.v2024_03_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.sellerwallet.v2024_03_01.BalanceType;

@Schema(description="Specifies the balance amount in the Amazon SW bank account")
public class Balance {
    @SerializedName(value="accountId")
    private String accountId = null;
    @SerializedName(value="balanceType")
    private BalanceType balanceType = null;
    @SerializedName(value="balanceAmount")
    private BigDecimal balanceAmount = null;
    @SerializedName(value="balanceCurrency")
    private String balanceCurrency = null;
    @SerializedName(value="lastUpdateDate")
    private OffsetDateTime lastUpdateDate = null;

    public Balance accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(example="amzn1.account.AGUGL2EM3ZHYSRJWH2UCRPIM5JFQ", required=true, description="The unique identifier provided by Amazon to identify the account ")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Balance balanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
        return this;
    }

    @Schema(description="")
    public BalanceType getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
    }

    public Balance balanceAmount(BigDecimal balanceAmount) {
        this.balanceAmount = balanceAmount;
        return this;
    }

    @Schema(required=true, description="")
    public BigDecimal getBalanceAmount() {
        return this.balanceAmount;
    }

    public void setBalanceAmount(BigDecimal balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public Balance balanceCurrency(String balanceCurrency) {
        this.balanceCurrency = balanceCurrency;
        return this;
    }

    @Schema(example="USD", required=true, description="The Amazon SW bank account currency code in ISO 4217 format ")
    public String getBalanceCurrency() {
        return this.balanceCurrency;
    }

    public void setBalanceCurrency(String balanceCurrency) {
        this.balanceCurrency = balanceCurrency;
    }

    public Balance lastUpdateDate(OffsetDateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    @Schema(required=true, description="The last update date on the account balance ")
    public OffsetDateTime getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(OffsetDateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        return Objects.equals(this.accountId, balance.accountId) && Objects.equals((Object)this.balanceType, (Object)balance.balanceType) && Objects.equals(this.balanceAmount, balance.balanceAmount) && Objects.equals(this.balanceCurrency, balance.balanceCurrency) && Objects.equals(this.lastUpdateDate, balance.lastUpdateDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.balanceType, this.balanceAmount, this.balanceCurrency, this.lastUpdateDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Balance {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    balanceType: ").append(this.toIndentedString((Object)this.balanceType)).append("\n");
        sb.append("    balanceAmount: ").append(this.toIndentedString(this.balanceAmount)).append("\n");
        sb.append("    balanceCurrency: ").append(this.toIndentedString(this.balanceCurrency)).append("\n");
        sb.append("    lastUpdateDate: ").append(this.toIndentedString(this.lastUpdateDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

