/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.sellers.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.sellers.v1.Address;

@Schema(description="Information about the seller's business. Certain fields may be omitted depending on the seller's `businessType`.")
public class Business {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="registeredBusinessAddress")
    private Address registeredBusinessAddress = null;
    @SerializedName(value="companyRegistrationNumber")
    private String companyRegistrationNumber = null;
    @SerializedName(value="companyTaxIdentificationNumber")
    private String companyTaxIdentificationNumber = null;
    @SerializedName(value="nonLatinName")
    private String nonLatinName = null;

    public Business name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The registered business name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Business registeredBusinessAddress(Address registeredBusinessAddress) {
        this.registeredBusinessAddress = registeredBusinessAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getRegisteredBusinessAddress() {
        return this.registeredBusinessAddress;
    }

    public void setRegisteredBusinessAddress(Address registeredBusinessAddress) {
        this.registeredBusinessAddress = registeredBusinessAddress;
    }

    public Business companyRegistrationNumber(String companyRegistrationNumber) {
        this.companyRegistrationNumber = companyRegistrationNumber;
        return this;
    }

    @Schema(description="The seller's company registration number, if applicable. This field will be absent for individual sellers and sole proprietorships.")
    public String getCompanyRegistrationNumber() {
        return this.companyRegistrationNumber;
    }

    public void setCompanyRegistrationNumber(String companyRegistrationNumber) {
        this.companyRegistrationNumber = companyRegistrationNumber;
    }

    public Business companyTaxIdentificationNumber(String companyTaxIdentificationNumber) {
        this.companyTaxIdentificationNumber = companyTaxIdentificationNumber;
        return this;
    }

    @Schema(description="The seller's company tax identification number, if applicable. This field will be present for certain business types only, such as sole proprietorships.")
    public String getCompanyTaxIdentificationNumber() {
        return this.companyTaxIdentificationNumber;
    }

    public void setCompanyTaxIdentificationNumber(String companyTaxIdentificationNumber) {
        this.companyTaxIdentificationNumber = companyTaxIdentificationNumber;
    }

    public Business nonLatinName(String nonLatinName) {
        this.nonLatinName = nonLatinName;
        return this;
    }

    @Schema(description="The non-Latin script version of the registered business name, if applicable.")
    public String getNonLatinName() {
        return this.nonLatinName;
    }

    public void setNonLatinName(String nonLatinName) {
        this.nonLatinName = nonLatinName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Business business = (Business)o;
        return Objects.equals(this.name, business.name) && Objects.equals(this.registeredBusinessAddress, business.registeredBusinessAddress) && Objects.equals(this.companyRegistrationNumber, business.companyRegistrationNumber) && Objects.equals(this.companyTaxIdentificationNumber, business.companyTaxIdentificationNumber) && Objects.equals(this.nonLatinName, business.nonLatinName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.registeredBusinessAddress, this.companyRegistrationNumber, this.companyTaxIdentificationNumber, this.nonLatinName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Business {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    registeredBusinessAddress: ").append(this.toIndentedString(this.registeredBusinessAddress)).append("\n");
        sb.append("    companyRegistrationNumber: ").append(this.toIndentedString(this.companyRegistrationNumber)).append("\n");
        sb.append("    companyTaxIdentificationNumber: ").append(this.toIndentedString(this.companyTaxIdentificationNumber)).append("\n");
        sb.append("    nonLatinName: ").append(this.toIndentedString(this.nonLatinName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

