/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.reports.v2021_06_30;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.reports.v2021_06_30.ReportOptions;

@Schema(description="Information required to create the report schedule.")
public class CreateReportScheduleSpecification {
    @SerializedName(value="reportType")
    private String reportType = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();
    @SerializedName(value="reportOptions")
    private ReportOptions reportOptions = null;
    @SerializedName(value="period")
    private PeriodEnum period = null;
    @SerializedName(value="nextReportCreationTime")
    private OffsetDateTime nextReportCreationTime = null;

    public CreateReportScheduleSpecification reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @Schema(required=true, description="The report type. Refer to [Report Type Values](https://developer-docs.amazon.com/sp-api/docs/report-type-values) for more information.")
    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public CreateReportScheduleSpecification marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public CreateReportScheduleSpecification addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(required=true, description="A list of marketplace identifiers for the report schedule.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public CreateReportScheduleSpecification reportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
        return this;
    }

    @Schema(description="")
    public ReportOptions getReportOptions() {
        return this.reportOptions;
    }

    public void setReportOptions(ReportOptions reportOptions) {
        this.reportOptions = reportOptions;
    }

    public CreateReportScheduleSpecification period(PeriodEnum period) {
        this.period = period;
        return this;
    }

    @Schema(required=true, description="One of a set of predefined <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> periods that specifies how often a report should be created.")
    public PeriodEnum getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodEnum period) {
        this.period = period;
    }

    public CreateReportScheduleSpecification nextReportCreationTime(OffsetDateTime nextReportCreationTime) {
        this.nextReportCreationTime = nextReportCreationTime;
        return this;
    }

    @Schema(description="The date and time when the schedule will create its next report, in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> date time format.")
    public OffsetDateTime getNextReportCreationTime() {
        return this.nextReportCreationTime;
    }

    public void setNextReportCreationTime(OffsetDateTime nextReportCreationTime) {
        this.nextReportCreationTime = nextReportCreationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateReportScheduleSpecification createReportScheduleSpecification = (CreateReportScheduleSpecification)o;
        return Objects.equals(this.reportType, createReportScheduleSpecification.reportType) && Objects.equals(this.marketplaceIds, createReportScheduleSpecification.marketplaceIds) && Objects.equals(this.reportOptions, createReportScheduleSpecification.reportOptions) && Objects.equals((Object)this.period, (Object)createReportScheduleSpecification.period) && Objects.equals(this.nextReportCreationTime, createReportScheduleSpecification.nextReportCreationTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reportType, this.marketplaceIds, this.reportOptions, this.period, this.nextReportCreationTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateReportScheduleSpecification {\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    reportOptions: ").append(this.toIndentedString(this.reportOptions)).append("\n");
        sb.append("    period: ").append(this.toIndentedString((Object)this.period)).append("\n");
        sb.append("    nextReportCreationTime: ").append(this.toIndentedString(this.nextReportCreationTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodEnum {
        PT5M("PT5M"),
        PT15M("PT15M"),
        PT30M("PT30M"),
        PT1H("PT1H"),
        PT2H("PT2H"),
        PT4H("PT4H"),
        PT8H("PT8H"),
        PT12H("PT12H"),
        P1D("P1D"),
        P2D("P2D"),
        P3D("P3D"),
        PT84H("PT84H"),
        P7D("P7D"),
        P14D("P14D"),
        P15D("P15D"),
        P18D("P18D"),
        P30D("P30D"),
        P1M("P1M");

        private String value;

        private PeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodEnum fromValue(String input) {
            for (PeriodEnum b : PeriodEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PeriodEnum> {
            public void write(JsonWriter jsonWriter, PeriodEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodEnum.fromValue(value);
            }
        }
    }
}

