/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.replenishment.v2022_11_07;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;
import software.amazon.spapi.models.replenishment.v2022_11_07.TimeInterval;

@Schema(description="An object which contains offer metrics.")
public class ListOfferMetricsResponseOffer {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="notDeliveredDueToOOS")
    private Double notDeliveredDueToOOS = null;
    @SerializedName(value="totalSubscriptionsRevenue")
    private Double totalSubscriptionsRevenue = null;
    @SerializedName(value="shippedSubscriptionUnits")
    private BigDecimal shippedSubscriptionUnits = null;
    @SerializedName(value="activeSubscriptions")
    private BigDecimal activeSubscriptions = null;
    @SerializedName(value="revenuePenetration")
    private Double revenuePenetration = null;
    @SerializedName(value="lostRevenueDueToOOS")
    private Double lostRevenueDueToOOS = null;
    @SerializedName(value="couponsRevenuePenetration")
    private Double couponsRevenuePenetration = null;
    @SerializedName(value="shareOfCouponSubscriptions")
    private Double shareOfCouponSubscriptions = null;
    @SerializedName(value="next30DayTotalSubscriptionsRevenue")
    private Double next30DayTotalSubscriptionsRevenue = null;
    @SerializedName(value="next60DayTotalSubscriptionsRevenue")
    private Double next60DayTotalSubscriptionsRevenue = null;
    @SerializedName(value="next90DayTotalSubscriptionsRevenue")
    private Double next90DayTotalSubscriptionsRevenue = null;
    @SerializedName(value="next30DayShippedSubscriptionUnits")
    private BigDecimal next30DayShippedSubscriptionUnits = null;
    @SerializedName(value="next60DayShippedSubscriptionUnits")
    private BigDecimal next60DayShippedSubscriptionUnits = null;
    @SerializedName(value="next90DayShippedSubscriptionUnits")
    private BigDecimal next90DayShippedSubscriptionUnits = null;
    @SerializedName(value="timeInterval")
    private TimeInterval timeInterval = null;
    @SerializedName(value="currencyCode")
    private String currencyCode = null;

    public ListOfferMetricsResponseOffer asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN).")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public ListOfferMetricsResponseOffer notDeliveredDueToOOS(Double notDeliveredDueToOOS) {
        this.notDeliveredDueToOOS = notDeliveredDueToOOS;
        return this;
    }

    @Schema(description="The percentage of items that were not shipped out of the total shipped units over a period of time due to being out of stock. Applicable to PERFORMANCE timePeriodType.")
    public Double getNotDeliveredDueToOOS() {
        return this.notDeliveredDueToOOS;
    }

    public void setNotDeliveredDueToOOS(Double notDeliveredDueToOOS) {
        this.notDeliveredDueToOOS = notDeliveredDueToOOS;
    }

    public ListOfferMetricsResponseOffer totalSubscriptionsRevenue(Double totalSubscriptionsRevenue) {
        this.totalSubscriptionsRevenue = totalSubscriptionsRevenue;
        return this;
    }

    @Schema(description="The revenue generated from subscriptions over a period of time. Applicable to PERFORMANCE timePeriodType.")
    public Double getTotalSubscriptionsRevenue() {
        return this.totalSubscriptionsRevenue;
    }

    public void setTotalSubscriptionsRevenue(Double totalSubscriptionsRevenue) {
        this.totalSubscriptionsRevenue = totalSubscriptionsRevenue;
    }

    public ListOfferMetricsResponseOffer shippedSubscriptionUnits(BigDecimal shippedSubscriptionUnits) {
        this.shippedSubscriptionUnits = shippedSubscriptionUnits;
        return this;
    }

    @Schema(description="The number of units shipped to the subscribers over a period of time. Applicable to PERFORMANCE timePeriodType.")
    public BigDecimal getShippedSubscriptionUnits() {
        return this.shippedSubscriptionUnits;
    }

    public void setShippedSubscriptionUnits(BigDecimal shippedSubscriptionUnits) {
        this.shippedSubscriptionUnits = shippedSubscriptionUnits;
    }

    public ListOfferMetricsResponseOffer activeSubscriptions(BigDecimal activeSubscriptions) {
        this.activeSubscriptions = activeSubscriptions;
        return this;
    }

    @Schema(description="The number of active subscriptions present at the end of the period. Applicable to PERFORMANCE timePeriodType.")
    public BigDecimal getActiveSubscriptions() {
        return this.activeSubscriptions;
    }

    public void setActiveSubscriptions(BigDecimal activeSubscriptions) {
        this.activeSubscriptions = activeSubscriptions;
    }

    public ListOfferMetricsResponseOffer revenuePenetration(Double revenuePenetration) {
        this.revenuePenetration = revenuePenetration;
        return this;
    }

    @Schema(description="The percentage of total program revenue out of total product revenue. Applicable to PERFORMANCE timePeriodType.")
    public Double getRevenuePenetration() {
        return this.revenuePenetration;
    }

    public void setRevenuePenetration(Double revenuePenetration) {
        this.revenuePenetration = revenuePenetration;
    }

    public ListOfferMetricsResponseOffer lostRevenueDueToOOS(Double lostRevenueDueToOOS) {
        this.lostRevenueDueToOOS = lostRevenueDueToOOS;
        return this;
    }

    @Schema(description="The revenue that would have been generated had there not been out of stock. Applicable to PERFORMANCE timePeriodType.")
    public Double getLostRevenueDueToOOS() {
        return this.lostRevenueDueToOOS;
    }

    public void setLostRevenueDueToOOS(Double lostRevenueDueToOOS) {
        this.lostRevenueDueToOOS = lostRevenueDueToOOS;
    }

    public ListOfferMetricsResponseOffer couponsRevenuePenetration(Double couponsRevenuePenetration) {
        this.couponsRevenuePenetration = couponsRevenuePenetration;
        return this;
    }

    @Schema(description="The percentage of revenue from ASINs with coupons out of total revenue from all ASINs. Applicable to PERFORMANCE timePeriodType.")
    public Double getCouponsRevenuePenetration() {
        return this.couponsRevenuePenetration;
    }

    public void setCouponsRevenuePenetration(Double couponsRevenuePenetration) {
        this.couponsRevenuePenetration = couponsRevenuePenetration;
    }

    public ListOfferMetricsResponseOffer shareOfCouponSubscriptions(Double shareOfCouponSubscriptions) {
        this.shareOfCouponSubscriptions = shareOfCouponSubscriptions;
        return this;
    }

    @Schema(description="The percentage of new subscriptions acquired through coupons. Applicable to PERFORMANCE timePeriodType.")
    public Double getShareOfCouponSubscriptions() {
        return this.shareOfCouponSubscriptions;
    }

    public void setShareOfCouponSubscriptions(Double shareOfCouponSubscriptions) {
        this.shareOfCouponSubscriptions = shareOfCouponSubscriptions;
    }

    public ListOfferMetricsResponseOffer next30DayTotalSubscriptionsRevenue(Double next30DayTotalSubscriptionsRevenue) {
        this.next30DayTotalSubscriptionsRevenue = next30DayTotalSubscriptionsRevenue;
        return this;
    }

    @Schema(description="The forecasted total subscription revenue for the next 30 days. Applicable to FORECAST timePeriodType.")
    public Double getNext30DayTotalSubscriptionsRevenue() {
        return this.next30DayTotalSubscriptionsRevenue;
    }

    public void setNext30DayTotalSubscriptionsRevenue(Double next30DayTotalSubscriptionsRevenue) {
        this.next30DayTotalSubscriptionsRevenue = next30DayTotalSubscriptionsRevenue;
    }

    public ListOfferMetricsResponseOffer next60DayTotalSubscriptionsRevenue(Double next60DayTotalSubscriptionsRevenue) {
        this.next60DayTotalSubscriptionsRevenue = next60DayTotalSubscriptionsRevenue;
        return this;
    }

    @Schema(description="The forecasted total subscription revenue for the next 60 days. Applicable to FORECAST timePeriodType.")
    public Double getNext60DayTotalSubscriptionsRevenue() {
        return this.next60DayTotalSubscriptionsRevenue;
    }

    public void setNext60DayTotalSubscriptionsRevenue(Double next60DayTotalSubscriptionsRevenue) {
        this.next60DayTotalSubscriptionsRevenue = next60DayTotalSubscriptionsRevenue;
    }

    public ListOfferMetricsResponseOffer next90DayTotalSubscriptionsRevenue(Double next90DayTotalSubscriptionsRevenue) {
        this.next90DayTotalSubscriptionsRevenue = next90DayTotalSubscriptionsRevenue;
        return this;
    }

    @Schema(description="The forecasted total subscription revenue for the next 90 days. Applicable to FORECAST timePeriodType.")
    public Double getNext90DayTotalSubscriptionsRevenue() {
        return this.next90DayTotalSubscriptionsRevenue;
    }

    public void setNext90DayTotalSubscriptionsRevenue(Double next90DayTotalSubscriptionsRevenue) {
        this.next90DayTotalSubscriptionsRevenue = next90DayTotalSubscriptionsRevenue;
    }

    public ListOfferMetricsResponseOffer next30DayShippedSubscriptionUnits(BigDecimal next30DayShippedSubscriptionUnits) {
        this.next30DayShippedSubscriptionUnits = next30DayShippedSubscriptionUnits;
        return this;
    }

    @Schema(description="The forecasted shipped subscription units for the next 30 days. Applicable to FORECAST timePeriodType.")
    public BigDecimal getNext30DayShippedSubscriptionUnits() {
        return this.next30DayShippedSubscriptionUnits;
    }

    public void setNext30DayShippedSubscriptionUnits(BigDecimal next30DayShippedSubscriptionUnits) {
        this.next30DayShippedSubscriptionUnits = next30DayShippedSubscriptionUnits;
    }

    public ListOfferMetricsResponseOffer next60DayShippedSubscriptionUnits(BigDecimal next60DayShippedSubscriptionUnits) {
        this.next60DayShippedSubscriptionUnits = next60DayShippedSubscriptionUnits;
        return this;
    }

    @Schema(description="The forecasted shipped subscription units for the next 60 days. Applicable to FORECAST timePeriodType.")
    public BigDecimal getNext60DayShippedSubscriptionUnits() {
        return this.next60DayShippedSubscriptionUnits;
    }

    public void setNext60DayShippedSubscriptionUnits(BigDecimal next60DayShippedSubscriptionUnits) {
        this.next60DayShippedSubscriptionUnits = next60DayShippedSubscriptionUnits;
    }

    public ListOfferMetricsResponseOffer next90DayShippedSubscriptionUnits(BigDecimal next90DayShippedSubscriptionUnits) {
        this.next90DayShippedSubscriptionUnits = next90DayShippedSubscriptionUnits;
        return this;
    }

    @Schema(description="The forecasted shipped subscription units for the next 90 days. Applicable to FORECAST timePeriodType.")
    public BigDecimal getNext90DayShippedSubscriptionUnits() {
        return this.next90DayShippedSubscriptionUnits;
    }

    public void setNext90DayShippedSubscriptionUnits(BigDecimal next90DayShippedSubscriptionUnits) {
        this.next90DayShippedSubscriptionUnits = next90DayShippedSubscriptionUnits;
    }

    public ListOfferMetricsResponseOffer timeInterval(TimeInterval timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    @Schema(description="")
    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        this.timeInterval = timeInterval;
    }

    public ListOfferMetricsResponseOffer currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="The currency code in ISO 4217 format.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListOfferMetricsResponseOffer listOfferMetricsResponseOffer = (ListOfferMetricsResponseOffer)o;
        return Objects.equals(this.asin, listOfferMetricsResponseOffer.asin) && Objects.equals(this.notDeliveredDueToOOS, listOfferMetricsResponseOffer.notDeliveredDueToOOS) && Objects.equals(this.totalSubscriptionsRevenue, listOfferMetricsResponseOffer.totalSubscriptionsRevenue) && Objects.equals(this.shippedSubscriptionUnits, listOfferMetricsResponseOffer.shippedSubscriptionUnits) && Objects.equals(this.activeSubscriptions, listOfferMetricsResponseOffer.activeSubscriptions) && Objects.equals(this.revenuePenetration, listOfferMetricsResponseOffer.revenuePenetration) && Objects.equals(this.lostRevenueDueToOOS, listOfferMetricsResponseOffer.lostRevenueDueToOOS) && Objects.equals(this.couponsRevenuePenetration, listOfferMetricsResponseOffer.couponsRevenuePenetration) && Objects.equals(this.shareOfCouponSubscriptions, listOfferMetricsResponseOffer.shareOfCouponSubscriptions) && Objects.equals(this.next30DayTotalSubscriptionsRevenue, listOfferMetricsResponseOffer.next30DayTotalSubscriptionsRevenue) && Objects.equals(this.next60DayTotalSubscriptionsRevenue, listOfferMetricsResponseOffer.next60DayTotalSubscriptionsRevenue) && Objects.equals(this.next90DayTotalSubscriptionsRevenue, listOfferMetricsResponseOffer.next90DayTotalSubscriptionsRevenue) && Objects.equals(this.next30DayShippedSubscriptionUnits, listOfferMetricsResponseOffer.next30DayShippedSubscriptionUnits) && Objects.equals(this.next60DayShippedSubscriptionUnits, listOfferMetricsResponseOffer.next60DayShippedSubscriptionUnits) && Objects.equals(this.next90DayShippedSubscriptionUnits, listOfferMetricsResponseOffer.next90DayShippedSubscriptionUnits) && Objects.equals(this.timeInterval, listOfferMetricsResponseOffer.timeInterval) && Objects.equals(this.currencyCode, listOfferMetricsResponseOffer.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.notDeliveredDueToOOS, this.totalSubscriptionsRevenue, this.shippedSubscriptionUnits, this.activeSubscriptions, this.revenuePenetration, this.lostRevenueDueToOOS, this.couponsRevenuePenetration, this.shareOfCouponSubscriptions, this.next30DayTotalSubscriptionsRevenue, this.next60DayTotalSubscriptionsRevenue, this.next90DayTotalSubscriptionsRevenue, this.next30DayShippedSubscriptionUnits, this.next60DayShippedSubscriptionUnits, this.next90DayShippedSubscriptionUnits, this.timeInterval, this.currencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListOfferMetricsResponseOffer {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    notDeliveredDueToOOS: ").append(this.toIndentedString(this.notDeliveredDueToOOS)).append("\n");
        sb.append("    totalSubscriptionsRevenue: ").append(this.toIndentedString(this.totalSubscriptionsRevenue)).append("\n");
        sb.append("    shippedSubscriptionUnits: ").append(this.toIndentedString(this.shippedSubscriptionUnits)).append("\n");
        sb.append("    activeSubscriptions: ").append(this.toIndentedString(this.activeSubscriptions)).append("\n");
        sb.append("    revenuePenetration: ").append(this.toIndentedString(this.revenuePenetration)).append("\n");
        sb.append("    lostRevenueDueToOOS: ").append(this.toIndentedString(this.lostRevenueDueToOOS)).append("\n");
        sb.append("    couponsRevenuePenetration: ").append(this.toIndentedString(this.couponsRevenuePenetration)).append("\n");
        sb.append("    shareOfCouponSubscriptions: ").append(this.toIndentedString(this.shareOfCouponSubscriptions)).append("\n");
        sb.append("    next30DayTotalSubscriptionsRevenue: ").append(this.toIndentedString(this.next30DayTotalSubscriptionsRevenue)).append("\n");
        sb.append("    next60DayTotalSubscriptionsRevenue: ").append(this.toIndentedString(this.next60DayTotalSubscriptionsRevenue)).append("\n");
        sb.append("    next90DayTotalSubscriptionsRevenue: ").append(this.toIndentedString(this.next90DayTotalSubscriptionsRevenue)).append("\n");
        sb.append("    next30DayShippedSubscriptionUnits: ").append(this.toIndentedString(this.next30DayShippedSubscriptionUnits)).append("\n");
        sb.append("    next60DayShippedSubscriptionUnits: ").append(this.toIndentedString(this.next60DayShippedSubscriptionUnits)).append("\n");
        sb.append("    next90DayShippedSubscriptionUnits: ").append(this.toIndentedString(this.next90DayShippedSubscriptionUnits)).append("\n");
        sb.append("    timeInterval: ").append(this.toIndentedString(this.timeInterval)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

