/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.replenishment.v2022_11_07;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="The discount funding on the offer.")
public class DiscountFunding {
    @SerializedName(value="percentage")
    private List<BigDecimal> percentage = null;

    public DiscountFunding percentage(List<BigDecimal> percentage) {
        this.percentage = percentage;
        return this;
    }

    public DiscountFunding addPercentageItem(BigDecimal percentageItem) {
        if (this.percentage == null) {
            this.percentage = new ArrayList<BigDecimal>();
        }
        this.percentage.add(percentageItem);
        return this;
    }

    @Schema(description="Filters the results to only include offers with the percentage specified.")
    public List<BigDecimal> getPercentage() {
        return this.percentage;
    }

    public void setPercentage(List<BigDecimal> percentage) {
        this.percentage = percentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscountFunding discountFunding = (DiscountFunding)o;
        return Objects.equals(this.percentage, discountFunding.percentage);
    }

    public int hashCode() {
        return Objects.hash(this.percentage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DiscountFunding {\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

