/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.producttypedefinitions.v2020_09_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Link to retrieve the schema.")
public class SchemaLinkLink {
    @SerializedName(value="resource")
    private String resource = null;
    @SerializedName(value="verb")
    private VerbEnum verb = null;

    public SchemaLinkLink resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Schema(required=true, description="URI resource for the link.")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public SchemaLinkLink verb(VerbEnum verb) {
        this.verb = verb;
        return this;
    }

    @Schema(required=true, description="HTTP method for the link operation.")
    public VerbEnum getVerb() {
        return this.verb;
    }

    public void setVerb(VerbEnum verb) {
        this.verb = verb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaLinkLink schemaLinkLink = (SchemaLinkLink)o;
        return Objects.equals(this.resource, schemaLinkLink.resource) && Objects.equals((Object)this.verb, (Object)schemaLinkLink.verb);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resource, this.verb});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaLinkLink {\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    verb: ").append(this.toIndentedString((Object)this.verb)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerbEnum {
        GET("GET");

        private String value;

        private VerbEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerbEnum fromValue(String input) {
            for (VerbEnum b : VerbEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerbEnum> {
            public void write(JsonWriter jsonWriter, VerbEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public VerbEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerbEnum.fromValue(value);
            }
        }
    }
}

