/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.producttypedefinitions.v2020_09_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The version details for an Amazon product type.")
public class ProductTypeVersion {
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="latest")
    private Boolean latest = null;
    @SerializedName(value="releaseCandidate")
    private Boolean releaseCandidate = null;

    public ProductTypeVersion version(String version) {
        this.version = version;
        return this;
    }

    @Schema(required=true, description="Version identifier.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProductTypeVersion latest(Boolean latest) {
        this.latest = latest;
        return this;
    }

    @Schema(required=true, description="When true, the version indicated by the version identifier is the latest available for the Amazon product type.")
    public Boolean isLatest() {
        return this.latest;
    }

    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    public ProductTypeVersion releaseCandidate(Boolean releaseCandidate) {
        this.releaseCandidate = releaseCandidate;
        return this;
    }

    @Schema(description="When true, the version indicated by the version identifier is the prerelease (release candidate) for the Amazon product type.")
    public Boolean isReleaseCandidate() {
        return this.releaseCandidate;
    }

    public void setReleaseCandidate(Boolean releaseCandidate) {
        this.releaseCandidate = releaseCandidate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductTypeVersion productTypeVersion = (ProductTypeVersion)o;
        return Objects.equals(this.version, productTypeVersion.version) && Objects.equals(this.latest, productTypeVersion.latest) && Objects.equals(this.releaseCandidate, productTypeVersion.releaseCandidate);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.latest, this.releaseCandidate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductTypeVersion {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    latest: ").append(this.toIndentedString(this.latest)).append("\n");
        sb.append("    releaseCandidate: ").append(this.toIndentedString(this.releaseCandidate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

