/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.producttypedefinitions.v2020_09_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.spapi.models.producttypedefinitions.v2020_09_01.ProductTypeVersion;
import software.amazon.spapi.models.producttypedefinitions.v2020_09_01.PropertyGroup;
import software.amazon.spapi.models.producttypedefinitions.v2020_09_01.SchemaLink;

@Schema(description="A product type definition represents the attributes and data requirements for a product type in the Amazon catalog. Product type definitions are used interchangeably between the Selling Partner API for Listings Items, Selling Partner API for Catalog Items, and JSON-based listings feeds in the Selling Partner API for Feeds.")
public class ProductTypeDefinition {
    @SerializedName(value="metaSchema")
    private SchemaLink metaSchema = null;
    @SerializedName(value="schema")
    private SchemaLink schema = null;
    @SerializedName(value="requirements")
    private RequirementsEnum requirements = null;
    @SerializedName(value="requirementsEnforced")
    private RequirementsEnforcedEnum requirementsEnforced = null;
    @SerializedName(value="propertyGroups")
    private Map<String, PropertyGroup> propertyGroups = new HashMap<String, PropertyGroup>();
    @SerializedName(value="locale")
    private String locale = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();
    @SerializedName(value="productType")
    private String productType = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="productTypeVersion")
    private ProductTypeVersion productTypeVersion = null;

    public ProductTypeDefinition metaSchema(SchemaLink metaSchema) {
        this.metaSchema = metaSchema;
        return this;
    }

    @Schema(description="")
    public SchemaLink getMetaSchema() {
        return this.metaSchema;
    }

    public void setMetaSchema(SchemaLink metaSchema) {
        this.metaSchema = metaSchema;
    }

    public ProductTypeDefinition schema(SchemaLink schema) {
        this.schema = schema;
        return this;
    }

    @Schema(required=true, description="")
    public SchemaLink getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaLink schema) {
        this.schema = schema;
    }

    public ProductTypeDefinition requirements(RequirementsEnum requirements) {
        this.requirements = requirements;
        return this;
    }

    @Schema(required=true, description="Name of the requirements set represented in this product type definition.")
    public RequirementsEnum getRequirements() {
        return this.requirements;
    }

    public void setRequirements(RequirementsEnum requirements) {
        this.requirements = requirements;
    }

    public ProductTypeDefinition requirementsEnforced(RequirementsEnforcedEnum requirementsEnforced) {
        this.requirementsEnforced = requirementsEnforced;
        return this;
    }

    @Schema(required=true, description="Identifies if the required attributes for a requirements set are enforced by the product type definition schema. Non-enforced requirements enable structural validation of individual attributes without all of the required attributes being present (such as for partial updates).")
    public RequirementsEnforcedEnum getRequirementsEnforced() {
        return this.requirementsEnforced;
    }

    public void setRequirementsEnforced(RequirementsEnforcedEnum requirementsEnforced) {
        this.requirementsEnforced = requirementsEnforced;
    }

    public ProductTypeDefinition propertyGroups(Map<String, PropertyGroup> propertyGroups) {
        this.propertyGroups = propertyGroups;
        return this;
    }

    public ProductTypeDefinition putPropertyGroupsItem(String key, PropertyGroup propertyGroupsItem) {
        this.propertyGroups.put(key, propertyGroupsItem);
        return this;
    }

    @Schema(required=true, description="Mapping of property group names to property groups. Property groups represent logical groupings of schema properties that can be used for display or informational purposes.")
    public Map<String, PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public void setPropertyGroups(Map<String, PropertyGroup> propertyGroups) {
        this.propertyGroups = propertyGroups;
    }

    public ProductTypeDefinition locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Schema(required=true, description="Locale of the display elements contained in the product type definition.")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public ProductTypeDefinition marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public ProductTypeDefinition addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(required=true, description="Amazon marketplace identifiers for which the product type definition is applicable.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public ProductTypeDefinition productType(String productType) {
        this.productType = productType;
        return this;
    }

    @Schema(required=true, description="The name of the Amazon product type that this product type definition applies to.")
    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public ProductTypeDefinition displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(required=true, description="Human-readable and localized description of the Amazon product type.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProductTypeDefinition productTypeVersion(ProductTypeVersion productTypeVersion) {
        this.productTypeVersion = productTypeVersion;
        return this;
    }

    @Schema(required=true, description="")
    public ProductTypeVersion getProductTypeVersion() {
        return this.productTypeVersion;
    }

    public void setProductTypeVersion(ProductTypeVersion productTypeVersion) {
        this.productTypeVersion = productTypeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductTypeDefinition productTypeDefinition = (ProductTypeDefinition)o;
        return Objects.equals(this.metaSchema, productTypeDefinition.metaSchema) && Objects.equals(this.schema, productTypeDefinition.schema) && Objects.equals((Object)this.requirements, (Object)productTypeDefinition.requirements) && Objects.equals((Object)this.requirementsEnforced, (Object)productTypeDefinition.requirementsEnforced) && Objects.equals(this.propertyGroups, productTypeDefinition.propertyGroups) && Objects.equals(this.locale, productTypeDefinition.locale) && Objects.equals(this.marketplaceIds, productTypeDefinition.marketplaceIds) && Objects.equals(this.productType, productTypeDefinition.productType) && Objects.equals(this.displayName, productTypeDefinition.displayName) && Objects.equals(this.productTypeVersion, productTypeDefinition.productTypeVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metaSchema, this.schema, this.requirements, this.requirementsEnforced, this.propertyGroups, this.locale, this.marketplaceIds, this.productType, this.displayName, this.productTypeVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductTypeDefinition {\n");
        sb.append("    metaSchema: ").append(this.toIndentedString(this.metaSchema)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString((Object)this.requirements)).append("\n");
        sb.append("    requirementsEnforced: ").append(this.toIndentedString((Object)this.requirementsEnforced)).append("\n");
        sb.append("    propertyGroups: ").append(this.toIndentedString(this.propertyGroups)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    productTypeVersion: ").append(this.toIndentedString(this.productTypeVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequirementsEnforcedEnum {
        ENFORCED("ENFORCED"),
        NOT_ENFORCED("NOT_ENFORCED");

        private String value;

        private RequirementsEnforcedEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequirementsEnforcedEnum fromValue(String input) {
            for (RequirementsEnforcedEnum b : RequirementsEnforcedEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RequirementsEnforcedEnum> {
            public void write(JsonWriter jsonWriter, RequirementsEnforcedEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RequirementsEnforcedEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequirementsEnforcedEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequirementsEnum {
        LISTING("LISTING"),
        LISTING_PRODUCT_ONLY("LISTING_PRODUCT_ONLY"),
        LISTING_OFFER_ONLY("LISTING_OFFER_ONLY");

        private String value;

        private RequirementsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequirementsEnum fromValue(String input) {
            for (RequirementsEnum b : RequirementsEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RequirementsEnum> {
            public void write(JsonWriter jsonWriter, RequirementsEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RequirementsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequirementsEnum.fromValue(value);
            }
        }
    }
}

