/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.producttypedefinitions.v2020_09_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="An Amazon product type with a definition available.")
public class ProductType {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = new ArrayList<String>();

    public ProductType name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The name of the Amazon product type.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProductType displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(required=true, description="The human-readable and localized description of the Amazon product type.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProductType marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public ProductType addMarketplaceIdsItem(String marketplaceIdsItem) {
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @Schema(required=true, description="The Amazon marketplace identifiers for which the product type definition is available.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductType productType = (ProductType)o;
        return Objects.equals(this.name, productType.name) && Objects.equals(this.displayName, productType.displayName) && Objects.equals(this.marketplaceIds, productType.marketplaceIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.marketplaceIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

