/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.productfees.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.productfees.v0.FeeDetailList;
import software.amazon.spapi.models.productfees.v0.MoneyType;

@Schema(description="The total estimated fees for an item and a list of details.")
public class FeesEstimate {
    @SerializedName(value="TimeOfFeesEstimation")
    private OffsetDateTime timeOfFeesEstimation = null;
    @SerializedName(value="TotalFeesEstimate")
    private MoneyType totalFeesEstimate = null;
    @SerializedName(value="FeeDetailList")
    private FeeDetailList feeDetailList = null;

    public FeesEstimate timeOfFeesEstimation(OffsetDateTime timeOfFeesEstimation) {
        this.timeOfFeesEstimation = timeOfFeesEstimation;
        return this;
    }

    @Schema(required=true, description="The time at which the fees were estimated. This defaults to the time the request is made.")
    public OffsetDateTime getTimeOfFeesEstimation() {
        return this.timeOfFeesEstimation;
    }

    public void setTimeOfFeesEstimation(OffsetDateTime timeOfFeesEstimation) {
        this.timeOfFeesEstimation = timeOfFeesEstimation;
    }

    public FeesEstimate totalFeesEstimate(MoneyType totalFeesEstimate) {
        this.totalFeesEstimate = totalFeesEstimate;
        return this;
    }

    @Schema(description="")
    public MoneyType getTotalFeesEstimate() {
        return this.totalFeesEstimate;
    }

    public void setTotalFeesEstimate(MoneyType totalFeesEstimate) {
        this.totalFeesEstimate = totalFeesEstimate;
    }

    public FeesEstimate feeDetailList(FeeDetailList feeDetailList) {
        this.feeDetailList = feeDetailList;
        return this;
    }

    @Schema(description="")
    public FeeDetailList getFeeDetailList() {
        return this.feeDetailList;
    }

    public void setFeeDetailList(FeeDetailList feeDetailList) {
        this.feeDetailList = feeDetailList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeesEstimate feesEstimate = (FeesEstimate)o;
        return Objects.equals(this.timeOfFeesEstimation, feesEstimate.timeOfFeesEstimation) && Objects.equals(this.totalFeesEstimate, feesEstimate.totalFeesEstimate) && Objects.equals(this.feeDetailList, feesEstimate.feeDetailList);
    }

    public int hashCode() {
        return Objects.hash(this.timeOfFeesEstimation, this.totalFeesEstimate, this.feeDetailList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeesEstimate {\n");
        sb.append("    timeOfFeesEstimation: ").append(this.toIndentedString(this.timeOfFeesEstimation)).append("\n");
        sb.append("    totalFeesEstimate: ").append(this.toIndentedString(this.totalFeesEstimate)).append("\n");
        sb.append("    feeDetailList: ").append(this.toIndentedString(this.feeDetailList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

