/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.MoneyType;

@Schema(description="The reference price for the specified ASIN `marketplaceId` combination.")
public class ReferencePrice {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="price")
    private MoneyType price = null;

    public ReferencePrice name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Reference price type (e.g., `CompetitivePriceThreshold`, `WasPrice`, `CompetitivePrice`). For definitions, see the [Product Pricing API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/product-pricing-api-v2022-05-01-use-case-guide).")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReferencePrice price(MoneyType price) {
        this.price = price;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getPrice() {
        return this.price;
    }

    public void setPrice(MoneyType price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferencePrice referencePrice = (ReferencePrice)o;
        return Objects.equals(this.name, referencePrice.name) && Objects.equals(this.price, referencePrice.price);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.price);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReferencePrice {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

