/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.FulfillmentType;

@Schema(description="Identifies an offer from a particular seller for a specified ASIN.")
public class OfferIdentifier {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="sellerId")
    private String sellerId = null;
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="fulfillmentType")
    private FulfillmentType fulfillmentType = null;

    public OfferIdentifier marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public OfferIdentifier sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(description="The seller identifier for the offer.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public OfferIdentifier sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(description="The seller SKU of the item. This will only be present for the target offer, which belongs to the requesting seller.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public OfferIdentifier asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(required=true, description="")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public OfferIdentifier fulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType;
        return this;
    }

    @Schema(description="")
    public FulfillmentType getFulfillmentType() {
        return this.fulfillmentType;
    }

    public void setFulfillmentType(FulfillmentType fulfillmentType) {
        this.fulfillmentType = fulfillmentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferIdentifier offerIdentifier = (OfferIdentifier)o;
        return Objects.equals(this.marketplaceId, offerIdentifier.marketplaceId) && Objects.equals(this.sellerId, offerIdentifier.sellerId) && Objects.equals(this.sku, offerIdentifier.sku) && Objects.equals(this.asin, offerIdentifier.asin) && Objects.equals((Object)this.fulfillmentType, (Object)offerIdentifier.fulfillmentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.sellerId, this.sku, this.asin, this.fulfillmentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferIdentifier {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    fulfillmentType: ").append(this.toIndentedString((Object)this.fulfillmentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

