/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.SegmentedFeaturedOffer;

@Schema(description="Describes a featured buying option, which includes a list of segmented featured offers for a particular item condition.")
public class FeaturedBuyingOption {
    @SerializedName(value="buyingOptionType")
    private BuyingOptionTypeEnum buyingOptionType = null;
    @SerializedName(value="segmentedFeaturedOffers")
    private List<SegmentedFeaturedOffer> segmentedFeaturedOffers = new ArrayList<SegmentedFeaturedOffer>();

    public FeaturedBuyingOption buyingOptionType(BuyingOptionTypeEnum buyingOptionType) {
        this.buyingOptionType = buyingOptionType;
        return this;
    }

    @Schema(required=true, description="The buying option type for the featured offer. `buyingOptionType` represents the buying options that a customer receives on the detail page, such as `B2B`, `Fresh`, and `Subscribe n Save`. `buyingOptionType` currently supports `NEW` as a value.")
    public BuyingOptionTypeEnum getBuyingOptionType() {
        return this.buyingOptionType;
    }

    public void setBuyingOptionType(BuyingOptionTypeEnum buyingOptionType) {
        this.buyingOptionType = buyingOptionType;
    }

    public FeaturedBuyingOption segmentedFeaturedOffers(List<SegmentedFeaturedOffer> segmentedFeaturedOffers) {
        this.segmentedFeaturedOffers = segmentedFeaturedOffers;
        return this;
    }

    public FeaturedBuyingOption addSegmentedFeaturedOffersItem(SegmentedFeaturedOffer segmentedFeaturedOffersItem) {
        this.segmentedFeaturedOffers.add(segmentedFeaturedOffersItem);
        return this;
    }

    @Schema(required=true, description="A list of segmented featured offers for the current buying option type. A segment can be considered as a group of regional contexts that all have the same featured offer. A regional context is a combination of factors such as customer type, region, or postal code and buying option.")
    public List<SegmentedFeaturedOffer> getSegmentedFeaturedOffers() {
        return this.segmentedFeaturedOffers;
    }

    public void setSegmentedFeaturedOffers(List<SegmentedFeaturedOffer> segmentedFeaturedOffers) {
        this.segmentedFeaturedOffers = segmentedFeaturedOffers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturedBuyingOption featuredBuyingOption = (FeaturedBuyingOption)o;
        return Objects.equals((Object)this.buyingOptionType, (Object)featuredBuyingOption.buyingOptionType) && Objects.equals(this.segmentedFeaturedOffers, featuredBuyingOption.segmentedFeaturedOffers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buyingOptionType, this.segmentedFeaturedOffers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeaturedBuyingOption {\n");
        sb.append("    buyingOptionType: ").append(this.toIndentedString((Object)this.buyingOptionType)).append("\n");
        sb.append("    segmentedFeaturedOffers: ").append(this.toIndentedString(this.segmentedFeaturedOffers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BuyingOptionTypeEnum {
        NEW("New");

        private String value;

        private BuyingOptionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BuyingOptionTypeEnum fromValue(String input) {
            for (BuyingOptionTypeEnum b : BuyingOptionTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BuyingOptionTypeEnum> {
            public void write(JsonWriter jsonWriter, BuyingOptionTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public BuyingOptionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BuyingOptionTypeEnum.fromValue(value);
            }
        }
    }
}

