/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.ErrorList;
import software.amazon.spapi.models.pricing.v2022_05_01.FeaturedBuyingOption;
import software.amazon.spapi.models.pricing.v2022_05_01.LowestPricedOffer;
import software.amazon.spapi.models.pricing.v2022_05_01.ReferencePrice;

@Schema(description="The `competitiveSummaryResponse` body for a requested ASIN and `marketplaceId`.")
public class CompetitiveSummaryResponseBody {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="featuredBuyingOptions")
    private List<FeaturedBuyingOption> featuredBuyingOptions = null;
    @SerializedName(value="lowestPricedOffers")
    private List<LowestPricedOffer> lowestPricedOffers = null;
    @SerializedName(value="referencePrices")
    private List<ReferencePrice> referencePrices = null;
    @SerializedName(value="errors")
    private ErrorList errors = null;

    public CompetitiveSummaryResponseBody asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(required=true, description="")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public CompetitiveSummaryResponseBody marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public CompetitiveSummaryResponseBody featuredBuyingOptions(List<FeaturedBuyingOption> featuredBuyingOptions) {
        this.featuredBuyingOptions = featuredBuyingOptions;
        return this;
    }

    public CompetitiveSummaryResponseBody addFeaturedBuyingOptionsItem(FeaturedBuyingOption featuredBuyingOptionsItem) {
        if (this.featuredBuyingOptions == null) {
            this.featuredBuyingOptions = new ArrayList<FeaturedBuyingOption>();
        }
        this.featuredBuyingOptions.add(featuredBuyingOptionsItem);
        return this;
    }

    @Schema(description="A list of featured buying options for the specified ASIN `marketplaceId` combination.")
    public List<FeaturedBuyingOption> getFeaturedBuyingOptions() {
        return this.featuredBuyingOptions;
    }

    public void setFeaturedBuyingOptions(List<FeaturedBuyingOption> featuredBuyingOptions) {
        this.featuredBuyingOptions = featuredBuyingOptions;
    }

    public CompetitiveSummaryResponseBody lowestPricedOffers(List<LowestPricedOffer> lowestPricedOffers) {
        this.lowestPricedOffers = lowestPricedOffers;
        return this;
    }

    public CompetitiveSummaryResponseBody addLowestPricedOffersItem(LowestPricedOffer lowestPricedOffersItem) {
        if (this.lowestPricedOffers == null) {
            this.lowestPricedOffers = new ArrayList<LowestPricedOffer>();
        }
        this.lowestPricedOffers.add(lowestPricedOffersItem);
        return this;
    }

    @Schema(description="A list of lowest priced offers for the specified ASIN `marketplaceId` combination.")
    public List<LowestPricedOffer> getLowestPricedOffers() {
        return this.lowestPricedOffers;
    }

    public void setLowestPricedOffers(List<LowestPricedOffer> lowestPricedOffers) {
        this.lowestPricedOffers = lowestPricedOffers;
    }

    public CompetitiveSummaryResponseBody referencePrices(List<ReferencePrice> referencePrices) {
        this.referencePrices = referencePrices;
        return this;
    }

    public CompetitiveSummaryResponseBody addReferencePricesItem(ReferencePrice referencePricesItem) {
        if (this.referencePrices == null) {
            this.referencePrices = new ArrayList<ReferencePrice>();
        }
        this.referencePrices.add(referencePricesItem);
        return this;
    }

    @Schema(description="A list of reference prices for the specified ASIN `marketplaceId` combination.")
    public List<ReferencePrice> getReferencePrices() {
        return this.referencePrices;
    }

    public void setReferencePrices(List<ReferencePrice> referencePrices) {
        this.referencePrices = referencePrices;
    }

    public CompetitiveSummaryResponseBody errors(ErrorList errors) {
        this.errors = errors;
        return this;
    }

    @Schema(description="")
    public ErrorList getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorList errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompetitiveSummaryResponseBody competitiveSummaryResponseBody = (CompetitiveSummaryResponseBody)o;
        return Objects.equals(this.asin, competitiveSummaryResponseBody.asin) && Objects.equals(this.marketplaceId, competitiveSummaryResponseBody.marketplaceId) && Objects.equals(this.featuredBuyingOptions, competitiveSummaryResponseBody.featuredBuyingOptions) && Objects.equals(this.lowestPricedOffers, competitiveSummaryResponseBody.lowestPricedOffers) && Objects.equals(this.referencePrices, competitiveSummaryResponseBody.referencePrices) && Objects.equals(this.errors, competitiveSummaryResponseBody.errors);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.marketplaceId, this.featuredBuyingOptions, this.lowestPricedOffers, this.referencePrices, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompetitiveSummaryResponseBody {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    featuredBuyingOptions: ").append(this.toIndentedString(this.featuredBuyingOptions)).append("\n");
        sb.append("    lowestPricedOffers: ").append(this.toIndentedString(this.lowestPricedOffers)).append("\n");
        sb.append("    referencePrices: ").append(this.toIndentedString(this.referencePrices)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

