/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v2022_05_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v2022_05_01.CompetitiveSummaryIncludedData;
import software.amazon.spapi.models.pricing.v2022_05_01.HttpMethod;
import software.amazon.spapi.models.pricing.v2022_05_01.LowestPricedOffersInput;

@Schema(description="An individual `competitiveSummary` request for an ASIN and `marketplaceId`.")
public class CompetitiveSummaryRequest {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="includedData")
    private List<CompetitiveSummaryIncludedData> includedData = new ArrayList<CompetitiveSummaryIncludedData>();
    @SerializedName(value="lowestPricedOffersInputs")
    private List<LowestPricedOffersInput> lowestPricedOffersInputs = null;
    @SerializedName(value="method")
    private HttpMethod method = null;
    @SerializedName(value="uri")
    private String uri = null;

    public CompetitiveSummaryRequest asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(required=true, description="")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public CompetitiveSummaryRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public CompetitiveSummaryRequest includedData(List<CompetitiveSummaryIncludedData> includedData) {
        this.includedData = includedData;
        return this;
    }

    public CompetitiveSummaryRequest addIncludedDataItem(CompetitiveSummaryIncludedData includedDataItem) {
        this.includedData.add(includedDataItem);
        return this;
    }

    @Schema(required=true, description="The list of requested competitive pricing data for the product.")
    public List<CompetitiveSummaryIncludedData> getIncludedData() {
        return this.includedData;
    }

    public void setIncludedData(List<CompetitiveSummaryIncludedData> includedData) {
        this.includedData = includedData;
    }

    public CompetitiveSummaryRequest lowestPricedOffersInputs(List<LowestPricedOffersInput> lowestPricedOffersInputs) {
        this.lowestPricedOffersInputs = lowestPricedOffersInputs;
        return this;
    }

    public CompetitiveSummaryRequest addLowestPricedOffersInputsItem(LowestPricedOffersInput lowestPricedOffersInputsItem) {
        if (this.lowestPricedOffersInputs == null) {
            this.lowestPricedOffersInputs = new ArrayList<LowestPricedOffersInput>();
        }
        this.lowestPricedOffersInputs.add(lowestPricedOffersInputsItem);
        return this;
    }

    @Schema(description="The list of `lowestPricedOffersInput` parameters that are used to build `lowestPricedOffers` in the response. This attribute is only valid if `lowestPricedOffers` is requested in `includedData`")
    public List<LowestPricedOffersInput> getLowestPricedOffersInputs() {
        return this.lowestPricedOffersInputs;
    }

    public void setLowestPricedOffersInputs(List<LowestPricedOffersInput> lowestPricedOffersInputs) {
        this.lowestPricedOffersInputs = lowestPricedOffersInputs;
    }

    public CompetitiveSummaryRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Schema(required=true, description="")
    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public CompetitiveSummaryRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(required=true, description="")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompetitiveSummaryRequest competitiveSummaryRequest = (CompetitiveSummaryRequest)o;
        return Objects.equals(this.asin, competitiveSummaryRequest.asin) && Objects.equals(this.marketplaceId, competitiveSummaryRequest.marketplaceId) && Objects.equals(this.includedData, competitiveSummaryRequest.includedData) && Objects.equals(this.lowestPricedOffersInputs, competitiveSummaryRequest.lowestPricedOffersInputs) && Objects.equals((Object)this.method, (Object)competitiveSummaryRequest.method) && Objects.equals(this.uri, competitiveSummaryRequest.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asin, this.marketplaceId, this.includedData, this.lowestPricedOffersInputs, this.method, this.uri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompetitiveSummaryRequest {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    includedData: ").append(this.toIndentedString(this.includedData)).append("\n");
        sb.append("    lowestPricedOffersInputs: ").append(this.toIndentedString(this.lowestPricedOffersInputs)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

